/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc;

import com.github.housepower.jdbc.ClickHouseConnection;
import com.github.housepower.jdbc.settings.ClickHouseConfig;
import com.github.housepower.jdbc.settings.ClickHouseDefines;
import com.github.housepower.jdbc.settings.SettingKey;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class NonRegisterDriver
implements Driver {
    private static final String JDBC_PREFIX = "jdbc:";
    private static final String CLICK_HOUSE_JDBC_PREFIX = "jdbc:clickhouse:";

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(CLICK_HOUSE_JDBC_PREFIX);
    }

    @Override
    public Connection connect(String url, Properties properties) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        ClickHouseConfig configure = new ClickHouseConfig(url, properties);
        return ClickHouseConnection.createClickHouseConnection(configure);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties properties) throws SQLException {
        ClickHouseConfig configure = new ClickHouseConfig(url, properties);
        int index = 0;
        DriverPropertyInfo[] driverPropertiesInfo = new DriverPropertyInfo[configure.settings().size()];
        for (Map.Entry<SettingKey, Object> entry : configure.settings().entrySet()) {
            String value = String.valueOf(entry.getValue());
            DriverPropertyInfo property = new DriverPropertyInfo(entry.getKey().name(), value);
            property.description = entry.getKey().describe();
            driverPropertiesInfo[index++] = property;
        }
        return driverPropertiesInfo;
    }

    @Override
    public int getMajorVersion() {
        return ClickHouseDefines.MAJOR_VERSION;
    }

    @Override
    public int getMinorVersion() {
        return ClickHouseDefines.MINOR_VERSION;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }
}

