/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.buffer;

import com.github.housepower.jdbc.buffer.BuffedReader;
import java.io.IOException;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;

public class CompressedBuffedReader
implements BuffedReader {
    private int position;
    private int capacity;
    private byte[] decompressed;
    private final BuffedReader buf;
    private final LZ4FastDecompressor lz4FastDecompressor = LZ4Factory.safeInstance().fastDecompressor();
    private static final int LZ4 = 130;
    private static final int NONE = 2;
    private static final int ZSTD = 144;

    public CompressedBuffedReader(BuffedReader buf) {
        this.buf = buf;
    }

    @Override
    public int readBinary() throws IOException {
        if (this.position == this.capacity) {
            this.decompressed = this.readCompressedData();
            this.position = 0;
            this.capacity = this.decompressed.length;
        }
        return this.decompressed[this.position++];
    }

    @Override
    public int readBinary(byte[] bytes) throws IOException {
        int i = 0;
        while (i < bytes.length) {
            int pending;
            int fillLength;
            if (this.position == this.capacity) {
                this.decompressed = this.readCompressedData();
                this.position = 0;
                this.capacity = this.decompressed.length;
            }
            if ((fillLength = Math.min(pending = bytes.length - i, this.capacity - this.position)) <= 0) continue;
            System.arraycopy(this.decompressed, this.position, bytes, i, fillLength);
            i += fillLength;
            this.position += fillLength;
        }
        return bytes.length;
    }

    private byte[] readCompressedData() throws IOException {
        this.buf.readBinary(new byte[16]);
        byte[] compressedHeader = new byte[9];
        if (this.buf.readBinary(compressedHeader) != 9) {
            throw new IOException("");
        }
        int method = this.unsignedByte(compressedHeader[0]);
        int compressedSize = this.readInt(compressedHeader, 1);
        int decompressedSize = this.readInt(compressedHeader, 5);
        switch (method) {
            case 130: {
                return this.readLZ4CompressedData(compressedSize - 9, decompressedSize);
            }
            case 2: {
                return this.readNoneCompressedData(decompressedSize);
            }
        }
        throw new UnsupportedOperationException("Unknown compression method: " + method);
    }

    private byte[] readNoneCompressedData(int size) throws IOException {
        byte[] decompressed = new byte[size];
        if (this.buf.readBinary(decompressed) != size) {
            throw new IOException("Cannot decompress use None method.");
        }
        return decompressed;
    }

    private byte[] readLZ4CompressedData(int compressedSize, int decompressedSize) throws IOException {
        byte[] decompressed;
        byte[] compressed = new byte[compressedSize];
        if (this.buf.readBinary(compressed) == compressedSize && this.lz4FastDecompressor.decompress(compressed, decompressed = new byte[decompressedSize]) == compressedSize) {
            return decompressed;
        }
        throw new IOException("Cannot decompress use LZ4 method.");
    }

    private int unsignedByte(byte byt) {
        return 0xFF & byt;
    }

    private int readInt(byte[] bytes, int begin) {
        return bytes[begin] & 0xFF | (bytes[begin + 1] & 0xFF) << 8 | (bytes[begin + 2] & 0xFF) << 16 | (0xFF & bytes[begin + 3]) << 24;
    }
}

