/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.buffer;

import com.github.housepower.jdbc.buffer.BuffedWriter;
import com.github.housepower.jdbc.misc.ClickHouseCityHash;
import java.io.IOException;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;

public class CompressedBuffedWriter
implements BuffedWriter {
    private int position;
    private int capacity;
    private final byte[] writtenBuf;
    private final BuffedWriter writer;
    private final LZ4Compressor lz4Compressor = LZ4Factory.safeInstance().fastCompressor();
    private static final int COMPRESSION_HEADER_LENGTH = 9;

    public CompressedBuffedWriter(int capacity, BuffedWriter writer) {
        this.capacity = capacity;
        this.writtenBuf = new byte[capacity];
        this.writer = writer;
    }

    @Override
    public void writeBinary(byte byt) throws IOException {
        this.writtenBuf[this.position++] = byt;
        this.flushToTarget(false);
    }

    @Override
    public void writeBinary(byte[] bytes) throws IOException {
        this.writeBinary(bytes, 0, bytes.length);
    }

    @Override
    public void writeBinary(byte[] bytes, int offset, int length) throws IOException {
        while (this.remaing() < length) {
            int num = this.remaing();
            System.arraycopy(bytes, offset, this.writtenBuf, this.position, this.remaing());
            this.position += num;
            this.flushToTarget(false);
            offset += num;
            length -= num;
        }
        System.arraycopy(bytes, offset, this.writtenBuf, this.position, length);
        this.position += length;
        this.flushToTarget(false);
    }

    @Override
    public void flushToTarget(boolean force) throws IOException {
        if (this.position > 0 && (force || !this.hasRemaining())) {
            int maxLen = this.lz4Compressor.maxCompressedLength(this.position);
            byte[] compressedBuffer = new byte[maxLen + 9 + 16];
            int res = this.lz4Compressor.compress(this.writtenBuf, 0, this.position, compressedBuffer, 25);
            compressedBuffer[16] = -126;
            int compressedSize = res + 9;
            System.arraycopy(this.littleEndian(compressedSize), 0, compressedBuffer, 17, 4);
            System.arraycopy(this.littleEndian(this.position), 0, compressedBuffer, 21, 4);
            long[] checksum = ClickHouseCityHash.cityHash128(compressedBuffer, 16, compressedSize);
            System.arraycopy(this.littleEndian(checksum[0]), 0, compressedBuffer, 0, 8);
            System.arraycopy(this.littleEndian(checksum[1]), 0, compressedBuffer, 8, 8);
            this.writer.writeBinary(compressedBuffer, 0, compressedSize + 16);
            this.position = 0;
        }
    }

    private boolean hasRemaining() {
        return this.position < this.capacity;
    }

    private int remaing() {
        return this.capacity - this.position;
    }

    private byte[] littleEndian(int x) {
        byte[] data = new byte[]{(byte)(x & 0xFF), (byte)((byte)(x >> 8) & 0xFF), (byte)((byte)(x >> 16) & 0xFF), (byte)((byte)(x >> 24) & 0xFF)};
        return data;
    }

    private byte[] littleEndian(long x) {
        byte[] data = new byte[]{(byte)(x & 0xFFL), (byte)((byte)(x >> 8) & 0xFF), (byte)((byte)(x >> 16) & 0xFF), (byte)((byte)(x >> 24) & 0xFF), (byte)((byte)(x >> 32) & 0xFF), (byte)((byte)(x >> 40) & 0xFF), (byte)((byte)(x >> 48) & 0xFF), (byte)((byte)(x >> 56) & 0xFF)};
        return data;
    }
}

