/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.data;

import com.github.housepower.jdbc.connect.PhysicalInfo;
import com.github.housepower.jdbc.data.BlockSettings;
import com.github.housepower.jdbc.data.Column;
import com.github.housepower.jdbc.data.DataTypeFactory;
import com.github.housepower.jdbc.data.IDataType;
import com.github.housepower.jdbc.misc.Validate;
import com.github.housepower.jdbc.serializer.BinaryDeserializer;
import com.github.housepower.jdbc.serializer.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class Block {
    private final Column[] columns;
    private final BlockSettings settings;
    private final Map<String, Integer> nameWithPosition;
    private Object[] objects;
    private int[] columnIndexAdds;
    private int rows;

    public Block() {
        this(0, new Column[0]);
    }

    public Block(int rows, Column[] columns) {
        this(rows, columns, new BlockSettings(BlockSettings.Setting.values()));
    }

    public Block(int rows, Column[] columns, BlockSettings settings) {
        this.rows = rows;
        this.columns = columns;
        this.settings = settings;
        this.objects = new Object[columns.length];
        this.columnIndexAdds = new int[columns.length];
        this.nameWithPosition = new HashMap<String, Integer>();
        for (int i = 0; i < columns.length; ++i) {
            this.nameWithPosition.put(columns[i].name(), i + 1);
            this.columnIndexAdds[i] = i;
        }
    }

    public void appendRow() throws SQLException {
        int i = 0;
        try {
            for (i = 0; i < this.columns.length; ++i) {
                this.columns[i].write(this.objects[i]);
            }
            ++this.rows;
        }
        catch (IOException e) {
            throw new SQLException("Exception processing value " + this.objects[i] + " for column : " + this.columns[i].name(), e);
        }
        catch (ClassCastException e) {
            throw new SQLException("Exception processing value " + this.objects[i] + " for column : " + this.columns[i].name(), e);
        }
    }

    public void setObject(int i, Object object) throws SQLException {
        this.objects[this.columnIndexAdds[i]] = object;
    }

    public void setConstObject(int i, Object object) throws SQLException {
        this.objects[i] = object;
    }

    public void incrIndex(int i) {
        int j = i;
        while (j < this.columnIndexAdds.length) {
            int n = j++;
            this.columnIndexAdds[n] = this.columnIndexAdds[n] + 1;
        }
    }

    public void writeTo(BinarySerializer serializer) throws IOException, SQLException {
        this.settings.writeTo(serializer);
        serializer.writeVarInt(this.columns.length);
        serializer.writeVarInt(this.rows);
        for (Column column : this.columns) {
            column.serializeBinaryBulk(serializer);
        }
    }

    public int rows() {
        return this.rows;
    }

    public int columns() {
        return this.columns.length;
    }

    public Column getByPosition(int column) throws SQLException {
        Validate.isTrue(column < this.columns.length, "Position " + column + " is out of bound in Block.getByPosition, max position = " + (this.columns.length - 1));
        return this.columns[column];
    }

    public int getPositionByName(String name) throws SQLException {
        Validate.isTrue(this.nameWithPosition.containsKey(name), "Column '" + name + "' does not exist");
        return this.nameWithPosition.get(name);
    }

    public Object getObject(int index) throws SQLException {
        Validate.isTrue(index < this.columns.length, "Position " + index + " is out of bound in Block.getByPosition, max position = " + (this.columns.length - 1));
        return this.objects[index];
    }

    public static Block readFrom(BinaryDeserializer deserializer, PhysicalInfo.ServerInfo serverInfo) throws IOException, SQLException {
        BlockSettings info = BlockSettings.readFrom(deserializer);
        int columns = (int)deserializer.readVarInt();
        int rows = (int)deserializer.readVarInt();
        Column[] cols = new Column[columns];
        for (int i = 0; i < columns; ++i) {
            String name = deserializer.readStringBinary();
            String type = deserializer.readStringBinary();
            IDataType dataType = DataTypeFactory.get(type, serverInfo);
            Object[] arr = dataType.deserializeBinaryBulk(rows, deserializer);
            cols[i] = new Column(name, dataType, arr);
        }
        return new Block(rows, cols, info);
    }

    public void initWriteBuffer() {
        for (Column column : this.columns) {
            column.initWriteBuffer();
        }
    }
}

