/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.data;

import com.github.housepower.jdbc.data.ColumnWriterBuffer;
import com.github.housepower.jdbc.data.IDataType;
import com.github.housepower.jdbc.data.type.complex.DataTypeArray;
import com.github.housepower.jdbc.serializer.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class Column {
    private final String name;
    private final IDataType type;
    private Object[] values;
    private ColumnWriterBuffer buffer;
    private boolean isArray;
    private List<List<Integer>> offsets;

    public Column(String name, IDataType type) {
        this.name = name;
        this.type = type;
    }

    public Column(String name, IDataType type, Object[] values) {
        this.values = values;
        this.name = name;
        this.type = type;
        if (this.type.sqlTypeId() == 2003) {
            this.isArray = true;
            this.offsets = new ArrayList<List<Integer>>();
        }
    }

    public void initWriteBuffer() {
        this.buffer = new ColumnWriterBuffer();
    }

    public String name() {
        return this.name;
    }

    public IDataType type() {
        return this.type;
    }

    public Object values(int rowIdx) {
        return this.values[rowIdx];
    }

    public void write(Object object) throws IOException, SQLException {
        if (this.isArray) {
            DataTypeArray typ = (DataTypeArray)this.type();
            typ.serializeBinary(object, this.buffer.column, this.offsets, 1);
        } else {
            this.type().serializeBinary(object, this.buffer.column);
        }
    }

    public void serializeBinaryBulk(BinarySerializer serializer) throws SQLException, IOException {
        serializer.writeStringBinary(this.name);
        serializer.writeStringBinary(this.type.name());
        if (this.offsets != null) {
            for (List<Integer> offsetList : this.offsets) {
                for (int offset : offsetList) {
                    serializer.writeLong(offset);
                }
            }
        }
        this.buffer.writeTo(serializer);
    }

    public ColumnWriterBuffer getBuffer() {
        return this.buffer;
    }
}

