/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.data.type;

import com.github.housepower.jdbc.connect.PhysicalInfo;
import com.github.housepower.jdbc.data.IDataType;
import com.github.housepower.jdbc.misc.SQLLexer;
import com.github.housepower.jdbc.misc.Validate;
import com.github.housepower.jdbc.serializer.BinaryDeserializer;
import com.github.housepower.jdbc.serializer.BinarySerializer;
import com.github.housepower.jdbc.settings.SettingKey;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.joda.time.DateTimeZone;

public class DataTypeDate
implements IDataType {
    private static final java.sql.Date DEFAULT_VALUE = new java.sql.Date(0L);
    private final DateTimeZone dateTimeZone;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public DataTypeDate(PhysicalInfo.ServerInfo serverInfo) {
        this.dateTimeZone = !Boolean.TRUE.equals(serverInfo.getConfigure().settings().get((Object)SettingKey.use_client_time_zone)) ? DateTimeZone.forTimeZone((TimeZone)serverInfo.timeZone()) : DateTimeZone.getDefault();
        this.dateFormat.setTimeZone(this.dateTimeZone.toTimeZone());
    }

    @Override
    public String name() {
        return "Date";
    }

    @Override
    public int sqlTypeId() {
        return 91;
    }

    @Override
    public Object defaultValue() {
        return DEFAULT_VALUE;
    }

    @Override
    public Class javaTypeClass() {
        return java.sql.Date.class;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public void serializeBinary(Object data, BinarySerializer serializer) throws SQLException, IOException {
        long mills = ((java.sql.Date)data).getTime();
        long daysSinceEpoch = mills / 1000L / 3600L / 24L;
        serializer.writeShort((short)daysSinceEpoch);
    }

    @Override
    public Object deserializeBinary(BinaryDeserializer deserializer) throws IOException {
        short daysSinceEpoch = deserializer.readShort();
        return new java.sql.Date(86400000L * (long)daysSinceEpoch);
    }

    @Override
    public Object[] deserializeBinaryBulk(int rows, BinaryDeserializer deserializer) throws IOException {
        Object[] data = new java.sql.Date[rows];
        for (int row = 0; row < rows; ++row) {
            short daysSinceEpoch = deserializer.readShort();
            data[row] = new java.sql.Date(86400000L * (long)daysSinceEpoch);
        }
        return data;
    }

    @Override
    public Object deserializeTextQuoted(SQLLexer lexer) throws SQLException {
        Validate.isTrue(lexer.character() == '\'');
        int year = lexer.numberLiteral().intValue();
        Validate.isTrue(lexer.character() == '-');
        int month = lexer.numberLiteral().intValue();
        Validate.isTrue(lexer.character() == '-');
        int day = lexer.numberLiteral().intValue();
        Validate.isTrue(lexer.character() == '\'');
        String timeStr = String.format("%04d-%02d-%02d", year, month, day);
        try {
            Date date = this.dateFormat.parse(timeStr);
            return new java.sql.Date(date.getTime());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static IDataType createDateType(SQLLexer lexer, PhysicalInfo.ServerInfo serverInfo) {
        return new DataTypeDate(serverInfo);
    }
}

