/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.data.type.complex;

import com.github.housepower.jdbc.connect.PhysicalInfo;
import com.github.housepower.jdbc.data.IDataType;
import com.github.housepower.jdbc.misc.SQLLexer;
import com.github.housepower.jdbc.misc.Validate;
import com.github.housepower.jdbc.serializer.BinaryDeserializer;
import com.github.housepower.jdbc.serializer.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

public class DataTypeEnum8
implements IDataType {
    private String name;
    private Byte[] values;
    private String[] names;

    public DataTypeEnum8(String name, String[] names, Byte[] values) {
        this.name = name;
        this.names = names;
        this.values = values;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int sqlTypeId() {
        return 12;
    }

    @Override
    public Object defaultValue() {
        return this.values[0];
    }

    @Override
    public Class javaTypeClass() {
        return String.class;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public Object deserializeTextQuoted(SQLLexer lexer) throws SQLException {
        return lexer.stringLiteral();
    }

    @Override
    public void serializeBinary(Object data, BinarySerializer serializer) throws SQLException, IOException {
        for (int i = 0; i < this.names.length; ++i) {
            if (!data.equals(this.names[i])) continue;
            serializer.writeByte(this.values[i]);
            return;
        }
        String message = "Expected ";
        for (int i = 0; i < this.names.length; ++i) {
            if (i > 0) {
                message = message + " OR ";
            }
            message = message + this.names[i];
        }
        throw new SQLException(message + " , but was " + String.valueOf(data));
    }

    @Override
    public Object deserializeBinary(BinaryDeserializer deserializer) throws SQLException, IOException {
        byte value = deserializer.readByte();
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.values[i].equals(value)) continue;
            return this.names[i];
        }
        throw new SQLException("");
    }

    @Override
    public Object[] deserializeBinaryBulk(int rows, BinaryDeserializer deserializer) throws SQLException, IOException {
        Object[] data = new String[rows];
        for (int row = 0; row < rows; ++row) {
            data[row] = (String)this.deserializeBinary(deserializer);
        }
        return data;
    }

    public static IDataType createEnum8Type(SQLLexer lexer, PhysicalInfo.ServerInfo serverInfo) throws SQLException {
        Validate.isTrue(lexer.character() == '(');
        ArrayList<Byte> enumValues = new ArrayList<Byte>();
        ArrayList<String> enumNames = new ArrayList<String>();
        for (int i = 0; i < 256; ++i) {
            enumNames.add(String.valueOf(lexer.stringLiteral()));
            Validate.isTrue(lexer.character() == '=');
            enumValues.add(lexer.numberLiteral().byteValue());
            char character = lexer.character();
            Validate.isTrue(character == ',' || character == ')');
            if (character != ')') continue;
            StringBuilder builder = new StringBuilder("Enum8(");
            for (int index = 0; index < enumNames.size(); ++index) {
                if (index > 0) {
                    builder.append(",");
                }
                builder.append("'").append((String)enumNames.get(index)).append("'").append(" = ").append(enumValues.get(index));
            }
            return new DataTypeEnum8(builder.append(")").toString(), enumNames.toArray(new String[enumNames.size()]), enumValues.toArray(new Byte[enumValues.size()]));
        }
        throw new SQLException("DataType Enum8 size must be less than 256");
    }
}

