/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.misc;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;

public class Slice
implements Iterable<Object> {
    private Object[] array;
    private int capacity;
    private int offset;
    private int pos;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public Slice(int capacity) {
        this.offset = 0;
        this.pos = 0;
        this.array = new Object[capacity];
        this.capacity = capacity;
    }

    public Slice(Object[] array) {
        this.offset = 0;
        this.pos = array.length;
        this.array = array;
        this.capacity = array.length;
    }

    public Slice(Slice slice, int offset, int pos) {
        this.array = slice.array;
        this.capacity = slice.capacity;
        this.offset = offset;
        this.pos = pos;
    }

    public int size() {
        return this.pos - this.offset;
    }

    public Slice sub(int offsetAdd, int posAdd) {
        return new Slice(this, this.offset + offsetAdd, this.offset + posAdd);
    }

    public Object get(int index) {
        return this.array[index + this.offset];
    }

    public void add(Object object) {
        if (this.pos >= this.capacity) {
            this.grow(this.capacity);
        }
        this.array[this.pos] = object;
        ++this.pos;
    }

    public void set(int index, Object object) {
        this.array[this.offset + index] = object;
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.array.length;
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = Slice.hugeCapacity(minCapacity);
        }
        this.array = Arrays.copyOf(this.array, newCapacity);
        this.capacity = newCapacity;
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    @Override
    public Iterator<Object> iterator() {
        return new SliceIterator(this);
    }

    @Override
    public void forEach(Consumer<? super Object> action) {
    }

    @Override
    public Spliterator<Object> spliterator() {
        return null;
    }

    public static class SliceIterator
    implements Iterator<Object> {
        int current;
        Slice slice;

        SliceIterator(Slice slice) {
            this.slice = slice;
            this.current = slice.offset;
        }

        @Override
        public boolean hasNext() {
            return this.current < this.slice.pos;
        }

        @Override
        public Object next() {
            Object obj = this.slice.array[this.current];
            ++this.current;
            return obj;
        }

        @Override
        public void remove() {
        }

        @Override
        public void forEachRemaining(Consumer<? super Object> action) {
        }
    }
}

