/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.serializer;

import com.github.housepower.jdbc.buffer.BuffedReader;
import com.github.housepower.jdbc.buffer.CompressedBuffedReader;
import com.github.housepower.jdbc.buffer.SocketBuffedReader;
import com.github.housepower.jdbc.misc.Container;
import java.io.IOException;
import java.net.Socket;

public class BinaryDeserializer {
    private final Container<BuffedReader> container;

    public BinaryDeserializer(Socket socket) throws IOException {
        SocketBuffedReader socketReader = new SocketBuffedReader(socket);
        this.container = new Container<CompressedBuffedReader>((CompressedBuffedReader)((Object)socketReader), new CompressedBuffedReader(socketReader));
    }

    public long readVarInt() throws IOException {
        int number = 0;
        for (int i = 0; i < 9; ++i) {
            int byt = this.container.get().readBinary();
            number |= (byt & 0x7F) << 7 * i;
            if ((byt & 0x80) == 0) break;
        }
        return number;
    }

    public short readShort() throws IOException {
        return (short)((this.container.get().readBinary() & 0xFF) + ((this.container.get().readBinary() & 0xFF) << 8));
    }

    public int readInt() throws IOException {
        return (this.container.get().readBinary() & 0xFF) + ((this.container.get().readBinary() & 0xFF) << 8) + ((this.container.get().readBinary() & 0xFF) << 16) + ((this.container.get().readBinary() & 0xFF) << 24);
    }

    public long readLong() throws IOException {
        return ((long)this.container.get().readBinary() & 0xFFL) + (((long)this.container.get().readBinary() & 0xFFL) << 8) + (((long)this.container.get().readBinary() & 0xFFL) << 16) + (((long)this.container.get().readBinary() & 0xFFL) << 24) + (((long)this.container.get().readBinary() & 0xFFL) << 32) + (((long)this.container.get().readBinary() & 0xFFL) << 40) + (((long)this.container.get().readBinary() & 0xFFL) << 48) + (((long)this.container.get().readBinary() & 0xFFL) << 56);
    }

    public boolean readBoolean() throws IOException {
        return this.container.get().readBinary() != 0;
    }

    public String readStringBinary() throws IOException {
        byte[] data = new byte[(int)this.readVarInt()];
        return this.container.get().readBinary(data) > 0 ? new String(data) : "";
    }

    public byte readByte() throws IOException {
        return (byte)this.container.get().readBinary();
    }

    public void maybeEnableCompressed() {
        this.container.select(true);
    }

    public void maybeDisenableCompressed() {
        this.container.select(false);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat((this.container.get().readBinary() & 0xFF) + ((this.container.get().readBinary() & 0xFF) << 8) + ((this.container.get().readBinary() & 0xFF) << 16) + (this.container.get().readBinary() << 24));
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(((long)this.container.get().readBinary() & 0xFFL) + (((long)this.container.get().readBinary() & 0xFFL) << 8) + (((long)this.container.get().readBinary() & 0xFFL) << 16) + (((long)this.container.get().readBinary() & 0xFFL) << 24) + (((long)this.container.get().readBinary() & 0xFFL) << 32) + (((long)this.container.get().readBinary() & 0xFFL) << 40) + (((long)this.container.get().readBinary() & 0xFFL) << 48) + (((long)this.container.get().readBinary() & 0xFFL) << 56));
    }

    public byte[] readBytes(int size) throws IOException {
        byte[] bytes = new byte[size];
        this.container.get().readBinary(bytes);
        return bytes;
    }
}

