/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.settings;

import com.github.housepower.jdbc.serializer.BinarySerializer;
import java.io.IOException;

public interface ISettingType {
    public static final ISettingType Int64 = new ISettingType(){

        @Override
        public Object deserializeURL(String queryParameter) {
            return Long.valueOf(queryParameter);
        }

        @Override
        public void serializeSetting(BinarySerializer serializer, Object value) throws IOException {
            serializer.writeVarInt((Long)value);
        }
    };
    public static final ISettingType Int32 = new ISettingType(){

        @Override
        public Object deserializeURL(String queryParameter) {
            return Integer.valueOf(queryParameter);
        }

        @Override
        public void serializeSetting(BinarySerializer serializer, Object value) throws IOException {
            serializer.writeVarInt(((Integer)value).intValue());
        }
    };
    public static final ISettingType Float = new ISettingType(){

        @Override
        public Object deserializeURL(String queryParameter) {
            return java.lang.Float.valueOf(queryParameter);
        }

        @Override
        public void serializeSetting(BinarySerializer serializer, Object value) throws IOException {
            serializer.writeStringBinary(java.lang.String.valueOf(value));
        }
    };
    public static final ISettingType String = new ISettingType(){

        @Override
        public Object deserializeURL(String queryParameter) {
            return queryParameter;
        }

        @Override
        public void serializeSetting(BinarySerializer serializer, Object value) throws IOException {
            serializer.writeStringBinary(java.lang.String.valueOf(value));
        }
    };
    public static final ISettingType Boolean = new ISettingType(){

        @Override
        public Object deserializeURL(String queryParameter) {
            return java.lang.Boolean.valueOf(queryParameter);
        }

        @Override
        public void serializeSetting(BinarySerializer serializer, Object value) throws IOException {
            serializer.writeVarInt(java.lang.Boolean.TRUE.equals(value) ? 1L : 0L);
        }
    };
    public static final ISettingType Seconds = new ISettingType(){

        @Override
        public Object deserializeURL(String queryParameter) {
            return Integer.valueOf(queryParameter);
        }

        @Override
        public void serializeSetting(BinarySerializer serializer, Object value) throws IOException {
            serializer.writeVarInt(((Integer)value).intValue());
        }
    };
    public static final ISettingType Character = new ISettingType(){

        @Override
        public Object deserializeURL(String queryParameter) {
            return java.lang.Character.valueOf(queryParameter.charAt(0));
        }

        @Override
        public void serializeSetting(BinarySerializer serializer, Object value) throws IOException {
            serializer.writeStringBinary(java.lang.String.valueOf(value));
        }
    };
    public static final ISettingType Milliseconds = new ISettingType(){

        @Override
        public Object deserializeURL(String queryParameter) {
            return Long.valueOf(queryParameter);
        }

        @Override
        public void serializeSetting(BinarySerializer serializer, Object value) throws IOException {
            serializer.writeVarInt((Long)value);
        }
    };

    public Object deserializeURL(String var1);

    public void serializeSetting(BinarySerializer var1, Object var2) throws IOException;
}

