/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.statement;

import com.github.housepower.jdbc.ClickHouseConnection;
import com.github.housepower.jdbc.data.Block;
import com.github.housepower.jdbc.misc.Validate;
import com.github.housepower.jdbc.statement.AbstractPreparedStatement;
import com.github.housepower.jdbc.stream.ValuesWithParametersInputFormat;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;

public class ClickHousePreparedInsertStatement
extends AbstractPreparedStatement {
    private final int posOfData;
    private final String fullQuery;
    private final String insertQuery;
    private boolean blockInit = false;

    public ClickHousePreparedInsertStatement(int posOfData, String fullQuery, ClickHouseConnection conn) throws SQLException {
        super(conn, null);
        this.posOfData = posOfData;
        this.fullQuery = fullQuery;
        this.insertQuery = fullQuery.substring(0, posOfData);
        this.initBlockIfPossible();
    }

    private void initBlockIfPossible() throws SQLException {
        if (this.blockInit) {
            return;
        }
        this.block = this.getSampleBlock(this.insertQuery);
        this.block.initWriteBuffer();
        this.blockInit = true;
        new ValuesWithParametersInputFormat(this.fullQuery, this.posOfData).fillBlock(this.block);
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeQuery() != null;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.addParameters();
        int result = this.connection.sendInsertRequest(this.block);
        this.blockInit = false;
        this.block.initWriteBuffer();
        return result;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.executeUpdate();
        return null;
    }

    @Override
    public void addBatch() throws SQLException {
        this.addParameters();
    }

    @Override
    public void setObject(int index, Object x) throws SQLException {
        this.initBlockIfPossible();
        this.block.setObject(index - 1, x);
    }

    private void addParameters() throws SQLException {
        this.block.appendRow();
    }

    @Override
    public void clearBatch() throws SQLException {
    }

    @Override
    public int[] executeBatch() throws SQLException {
        Integer rows = this.connection.sendInsertRequest(this.block);
        int[] result = new int[rows.intValue()];
        Arrays.fill(result, -1);
        this.clearBatch();
        this.blockInit = false;
        this.block.initWriteBuffer();
        return result;
    }

    @Override
    public void close() throws SQLException {
        if (this.blockInit) {
            this.connection.sendInsertRequest(new Block());
            this.blockInit = false;
            this.block.initWriteBuffer();
        }
        super.close();
    }

    private static int computeQuestionMarkSize(String query, int start) throws SQLException {
        int param = 0;
        boolean inQuotes = false;
        boolean inBackQuotes = false;
        for (int i = 0; i < query.length(); ++i) {
            char ch = query.charAt(i);
            if (ch == '`') {
                inBackQuotes = !inBackQuotes;
                continue;
            }
            if (ch == '\'') {
                inQuotes = !inQuotes;
                continue;
            }
            if (inBackQuotes || inQuotes || ch != '?') continue;
            Validate.isTrue(i > start, "");
            ++param;
        }
        return param;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(": ");
        try {
            sb.append(this.insertQuery + " (");
            for (int i = 0; i < this.block.columns(); ++i) {
                Object obj = this.block.getObject(i);
                if (obj == null) {
                    sb.append("?");
                } else if (obj instanceof Number) {
                    sb.append(obj);
                } else {
                    sb.append("'" + obj + "'");
                }
                if (i >= this.block.columns() - 1) continue;
                sb.append(",");
            }
            sb.append(")");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }
}

