/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.statement;

import com.github.housepower.jdbc.ClickHouseConnection;
import com.github.housepower.jdbc.ClickHouseResultSet;
import com.github.housepower.jdbc.data.Block;
import com.github.housepower.jdbc.protocol.QueryResponse;
import com.github.housepower.jdbc.stream.ValuesInputFormat;
import com.github.housepower.jdbc.wrapper.SQLStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClickHouseStatement
extends SQLStatement {
    private static final Pattern VALUES_REGEX = Pattern.compile("[V|v][A|a][L|l][U|u][E|e][S|s]\\s*\\(");
    private ResultSet lastResultSet;
    protected Block block;
    protected final ClickHouseConnection connection;

    public ClickHouseStatement(ClickHouseConnection connection) {
        this.connection = connection;
    }

    @Override
    public boolean execute(String query) throws SQLException {
        return this.executeQuery(query) != null;
    }

    @Override
    public ResultSet executeQuery(String query) throws SQLException {
        this.executeUpdate(query);
        return this.getResultSet();
    }

    @Override
    public int executeUpdate(String query) throws SQLException {
        Matcher matcher = VALUES_REGEX.matcher(query);
        if (matcher.find()) {
            this.lastResultSet = null;
            String insertQuery = query.substring(0, matcher.end() - 1);
            this.block = this.getSampleBlock(insertQuery);
            this.block.initWriteBuffer();
            new ValuesInputFormat(matcher.end() - 1, query).fillBlock(this.block);
            return this.connection.sendInsertRequest(this.block);
        }
        QueryResponse response = this.connection.sendQueryRequest(query);
        this.lastResultSet = new ClickHouseResultSet(response.header(), response.data().get(), this);
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.lastResultSet;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.lastResultSet.getMetaData();
    }

    public Block getSampleBlock(String insertQuery) throws SQLException {
        return this.connection.getSampleBlock(insertQuery);
    }
}

