/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.stream;

import com.github.housepower.jdbc.data.Block;
import com.github.housepower.jdbc.misc.SQLLexer;
import com.github.housepower.jdbc.misc.Validate;
import com.github.housepower.jdbc.stream.InputFormat;
import java.sql.SQLException;

public class ValuesInputFormat
implements InputFormat {
    private final SQLLexer lexer;

    public ValuesInputFormat(int pos, String data) throws SQLException {
        this.lexer = new SQLLexer(pos, data);
    }

    @Override
    public void fillBlock(Block block) throws SQLException {
        int[] constIdx = new int[block.columns()];
        while (true) {
            char nextChar = this.lexer.character();
            if (this.lexer.eof() || nextChar == ';') break;
            if (nextChar == ',') {
                nextChar = this.lexer.character();
            }
            Validate.isTrue(nextChar == '(');
            for (int column = 0; column < block.columns(); ++column) {
                if (column > 0) {
                    Validate.isTrue(this.lexer.character() == ',');
                }
                constIdx[column] = 1;
                block.setConstObject(column, block.getByPosition(column).type().deserializeTextQuoted(this.lexer));
            }
            Validate.isTrue(this.lexer.character() == ')');
            block.appendRow();
        }
        for (int column = 0; column < block.columns(); ++column) {
            if (constIdx[column] <= 0) continue;
            block.incrIndex(column);
        }
    }
}

