/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.stream;

import com.github.housepower.jdbc.data.Block;
import com.github.housepower.jdbc.misc.SQLLexer;
import com.github.housepower.jdbc.misc.Validate;
import com.github.housepower.jdbc.stream.InputFormat;
import java.sql.SQLException;

public class ValuesWithParametersInputFormat
implements InputFormat {
    private SQLLexer lexer;

    public ValuesWithParametersInputFormat(String query, int pos) throws SQLException {
        this.lexer = new SQLLexer(pos, query);
    }

    @Override
    public void fillBlock(Block block) throws SQLException {
        int column;
        int[] constIdx = new int[block.columns()];
        char nextChar = this.lexer.character();
        Validate.isTrue(nextChar == '(');
        for (column = 0; column < block.columns(); ++column) {
            if (column > 0) {
                Validate.isTrue(this.lexer.character() == ',');
            }
            if (!this.lexer.isCharacter('?')) {
                block.setConstObject(column, block.getByPosition(column).type().deserializeTextQuoted(this.lexer));
                constIdx[column] = 1;
                continue;
            }
            this.lexer.character();
        }
        for (column = 0; column < block.columns(); ++column) {
            if (constIdx[column] <= 0) continue;
            block.incrIndex(column);
        }
        Validate.isTrue(this.lexer.character() == ')');
    }
}

