/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.buffer;

import com.github.housepower.jdbc.buffer.BuffedWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class ByteArrayWriter
implements BuffedWriter {
    private final int blockSize;
    private ByteBuffer buffer;
    private final List<ByteBuffer> byteBufferList = new LinkedList<ByteBuffer>();

    public ByteArrayWriter(int blockSize) {
        this.blockSize = blockSize;
        this.buffer = ByteBuffer.allocate(blockSize);
        this.byteBufferList.add(this.buffer);
    }

    @Override
    public void writeBinary(byte byt) throws IOException {
        this.buffer.put(byt);
        this.flushToTarget(false);
    }

    @Override
    public void writeBinary(byte[] bytes) throws IOException {
        this.writeBinary(bytes, 0, bytes.length);
    }

    @Override
    public void writeBinary(byte[] bytes, int offset, int length) throws IOException {
        while (this.buffer.remaining() < length) {
            int num = this.buffer.remaining();
            this.buffer.put(bytes, offset, num);
            this.flushToTarget(true);
            offset += num;
            length -= num;
        }
        this.buffer.put(bytes, offset, length);
        this.flushToTarget(false);
    }

    @Override
    public void flushToTarget(boolean force) throws IOException {
        if (this.buffer.hasRemaining() && !force) {
            return;
        }
        this.buffer = ByteBuffer.allocate(this.blockSize);
        this.byteBufferList.add(this.buffer);
    }

    public List<ByteBuffer> getBufferList() {
        return this.byteBufferList;
    }
}

