/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.misc;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache<K, V> {
    private static final float HASH_TABLE_LOAD_FACTOR = 0.75f;
    private final int cacheSize;
    private final LinkedHashMap<K, V> map;

    public LRUCache(int cacheSize) {
        this.cacheSize = cacheSize;
        this.map = new LinkedHashMap<K, V>(cacheSize, 0.75f, true){

            @Override
            public boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > LRUCache.this.cacheSize;
            }
        };
    }

    public synchronized V get(K key) {
        return this.map.get(key);
    }

    public synchronized void put(K key, V value) {
        this.map.remove(key);
        this.map.put(key, value);
    }

    public synchronized void putIfAbsent(K key, V value) {
        this.map.putIfAbsent(key, value);
    }

    public synchronized void clear() {
        this.map.clear();
    }

    public synchronized int cacheSize() {
        return this.map.size();
    }
}

