/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.protocol;

import com.github.housepower.jdbc.protocol.Response;
import com.github.housepower.jdbc.serde.BinaryDeserializer;
import java.io.IOException;

public class ProfileInfoResponse
implements Response {
    private final long rows;
    private final long blocks;
    private final long bytes;
    private final long appliedLimit;
    private final long rowsBeforeLimit;
    private final boolean calculatedRowsBeforeLimit;

    public static ProfileInfoResponse readFrom(BinaryDeserializer deserializer) throws IOException {
        long rows = deserializer.readVarInt();
        long blocks = deserializer.readVarInt();
        long bytes = deserializer.readVarInt();
        long appliedLimit = deserializer.readVarInt();
        long rowsBeforeLimit = deserializer.readVarInt();
        boolean calculatedRowsBeforeLimit = deserializer.readBoolean();
        return new ProfileInfoResponse(rows, blocks, bytes, appliedLimit, rowsBeforeLimit, calculatedRowsBeforeLimit);
    }

    public ProfileInfoResponse(long rows, long blocks, long bytes, long appliedLimit, long rowsBeforeLimit, boolean calculatedRowsBeforeLimit) {
        this.rows = rows;
        this.blocks = blocks;
        this.bytes = bytes;
        this.appliedLimit = appliedLimit;
        this.rowsBeforeLimit = rowsBeforeLimit;
        this.calculatedRowsBeforeLimit = calculatedRowsBeforeLimit;
    }

    @Override
    public Response.ProtoType type() {
        return Response.ProtoType.RESPONSE_PROFILE_INFO;
    }

    public long rows() {
        return this.rows;
    }

    public long blocks() {
        return this.blocks;
    }

    public long bytes() {
        return this.bytes;
    }

    public long appliedLimit() {
        return this.appliedLimit;
    }

    public long rowsBeforeLimit() {
        return this.rowsBeforeLimit;
    }

    public boolean calculatedRowsBeforeLimit() {
        return this.calculatedRowsBeforeLimit;
    }
}

