/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.serde;

import com.github.housepower.jdbc.buffer.BuffedWriter;
import com.github.housepower.jdbc.buffer.CompressedBuffedWriter;
import com.github.housepower.jdbc.misc.Either;
import com.github.housepower.jdbc.settings.ClickHouseDefines;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class BinarySerializer {
    private final Either<BuffedWriter> either;
    private final boolean enableCompress;

    public BinarySerializer(BuffedWriter writer, boolean enableCompress) {
        this.enableCompress = enableCompress;
        CompressedBuffedWriter compressBuffer = null;
        if (enableCompress) {
            compressBuffer = new CompressedBuffedWriter(ClickHouseDefines.SOCKET_SEND_BUFFER_BYTES, writer);
        }
        this.either = new Either<CompressedBuffedWriter>((CompressedBuffedWriter)writer, compressBuffer);
    }

    public void writeVarInt(long x) throws IOException {
        for (int i = 0; i < 9; ++i) {
            byte byt = (byte)(x & 0x7FL);
            if (x > 127L) {
                byt = (byte)(byt | 0x80);
            }
            this.either.get().writeBinary(byt);
            if ((x >>= 7) != 0L) continue;
            return;
        }
    }

    public void writeByte(byte x) throws IOException {
        this.either.get().writeBinary(x);
    }

    public void writeBoolean(boolean x) throws IOException {
        this.writeVarInt((byte)(x ? 1 : 0));
    }

    public void writeShort(short i) throws IOException {
        this.either.get().writeBinary((byte)(i >> 0 & 0xFF));
        this.either.get().writeBinary((byte)(i >> 8 & 0xFF));
    }

    public void writeInt(int i) throws IOException {
        this.either.get().writeBinary((byte)(i >> 0 & 0xFF));
        this.either.get().writeBinary((byte)(i >> 8 & 0xFF));
        this.either.get().writeBinary((byte)(i >> 16 & 0xFF));
        this.either.get().writeBinary((byte)(i >> 24 & 0xFF));
    }

    public void writeLong(long i) throws IOException {
        this.either.get().writeBinary((byte)(i >> 0 & 0xFFL));
        this.either.get().writeBinary((byte)(i >> 8 & 0xFFL));
        this.either.get().writeBinary((byte)(i >> 16 & 0xFFL));
        this.either.get().writeBinary((byte)(i >> 24 & 0xFFL));
        this.either.get().writeBinary((byte)(i >> 32 & 0xFFL));
        this.either.get().writeBinary((byte)(i >> 40 & 0xFFL));
        this.either.get().writeBinary((byte)(i >> 48 & 0xFFL));
        this.either.get().writeBinary((byte)(i >> 56 & 0xFFL));
    }

    public void writeUTF8StringBinary(String utf8) throws IOException {
        this.writeStringBinary(utf8, StandardCharsets.UTF_8);
    }

    public void writeStringBinary(String data, Charset charset) throws IOException {
        byte[] bs = data.getBytes(charset);
        this.writeBytesBinary(bs);
    }

    public void writeBytesBinary(byte[] bs) throws IOException {
        this.writeVarInt(bs.length);
        this.either.get().writeBinary(bs);
    }

    public void flushToTarget(boolean force) throws IOException {
        this.either.get().flushToTarget(force);
    }

    public void maybeEnableCompressed() {
        if (this.enableCompress) {
            this.either.select(true);
        }
    }

    public void maybeDisableCompressed() throws IOException {
        if (this.enableCompress) {
            this.either.get().flushToTarget(true);
            this.either.select(false);
        }
    }

    public void writeFloat(float datum) throws IOException {
        int x = Float.floatToIntBits(datum);
        this.writeInt(x);
    }

    public void writeDouble(double datum) throws IOException {
        long x = Double.doubleToLongBits(datum);
        this.either.get().writeBinary((byte)(x >>> 0 & 0xFFL));
        this.either.get().writeBinary((byte)(x >>> 8 & 0xFFL));
        this.either.get().writeBinary((byte)(x >>> 16 & 0xFFL));
        this.either.get().writeBinary((byte)(x >>> 24 & 0xFFL));
        this.either.get().writeBinary((byte)(x >>> 32 & 0xFFL));
        this.either.get().writeBinary((byte)(x >>> 40 & 0xFFL));
        this.either.get().writeBinary((byte)(x >>> 48 & 0xFFL));
        this.either.get().writeBinary((byte)(x >>> 56 & 0xFFL));
    }

    public void writeBytes(byte[] bytes) throws IOException {
        this.either.get().writeBinary(bytes);
    }
}

