/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.statement;

import com.github.housepower.jdbc.ClickHouseConnection;
import com.github.housepower.jdbc.connect.NativeContext;
import com.github.housepower.jdbc.misc.DateTimeUtil;
import com.github.housepower.jdbc.misc.Validate;
import com.github.housepower.jdbc.statement.ClickHouseStatement;
import com.github.housepower.jdbc.wrapper.SQLPreparedStatement;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import java.util.regex.Matcher;

public abstract class AbstractPreparedStatement
extends ClickHouseStatement
implements SQLPreparedStatement {
    private final String[] queryParts;
    private final DateTimeFormatter dateFmt;
    private final DateTimeFormatter timestampFmt;
    protected final ZoneId tz;
    protected Object[] parameters;

    public AbstractPreparedStatement(ClickHouseConnection connection, NativeContext nativeContext, String[] queryParts) {
        super(connection, nativeContext);
        this.queryParts = queryParts;
        if (queryParts != null && queryParts.length > 0) {
            this.parameters = new Object[queryParts.length];
        }
        this.tz = DateTimeUtil.chooseTimeZone(nativeContext.serverCtx());
        this.dateFmt = DateTimeFormatter.ofPattern("yyyy-MM-dd", Locale.ROOT).withZone(this.tz);
        this.timestampFmt = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.ROOT).withZone(this.tz);
    }

    @Override
    public void setBoolean(int index, boolean x) throws SQLException {
        this.setObject(index, x ? (byte)1 : 0);
    }

    @Override
    public void setByte(int index, byte x) throws SQLException {
        this.setObject(index, x);
    }

    @Override
    public void setShort(int index, short x) throws SQLException {
        this.setObject(index, x);
    }

    @Override
    public void setInt(int index, int x) throws SQLException {
        this.setObject(index, x);
    }

    @Override
    public void setLong(int index, long x) throws SQLException {
        this.setObject(index, x);
    }

    @Override
    public void setFloat(int index, float x) throws SQLException {
        this.setObject(index, Float.valueOf(x));
    }

    @Override
    public void setDouble(int index, double x) throws SQLException {
        this.setObject(index, x);
    }

    @Override
    public void setNull(int index, int type) throws SQLException {
        this.setObject(index, null);
    }

    @Override
    public void setTimestamp(int index, Timestamp x) throws SQLException {
        this.setObject(index, DateTimeUtil.toZonedDateTime(x, this.tz));
    }

    @Override
    public void setTimestamp(int index, Timestamp x, Calendar cal) throws SQLException {
        this.setObject(index, DateTimeUtil.toZonedDateTime(x, cal.getTimeZone().toZoneId()));
    }

    @Override
    public void setDate(int index, Date x) throws SQLException {
        this.setObject(index, x.toLocalDate());
    }

    @Override
    public void setBigDecimal(int index, BigDecimal x) throws SQLException {
        this.setObject(index, x);
    }

    @Override
    public void setString(int index, String x) throws SQLException {
        this.setObject(index, x);
    }

    @Override
    public void setBytes(int index, byte[] x) throws SQLException {
        this.setObject(index, x);
    }

    @Override
    public void setURL(int index, URL x) throws SQLException {
        this.setObject(index, x);
    }

    @Override
    public void setArray(int index, Array x) throws SQLException {
        this.setObject(index, x);
    }

    @Override
    public void setObject(int index, Object x, int targetSqlType) throws SQLException {
        this.setObject(index, x);
    }

    @Override
    public void setObject(int index, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(index, x);
    }

    protected Object convertObjectIfNecessary(Object obj) {
        Object result = obj;
        if (obj instanceof Date) {
            result = ((Date)obj).toLocalDate();
        }
        if (obj instanceof Timestamp) {
            result = DateTimeUtil.toZonedDateTime((Timestamp)obj, this.tz);
        }
        if (obj instanceof LocalDateTime) {
            result = ((LocalDateTime)obj).atZone(this.tz);
        }
        return result;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.getResultSet().getMetaData();
    }

    @Override
    public void clearParameters() throws SQLException {
        if (this.parameters != null) {
            Arrays.fill(this.parameters, null);
        }
    }

    protected String assembleQueryPartsAndParameters() throws SQLException {
        StringBuilder queryBuilder = new StringBuilder();
        for (int i = 0; i < this.queryParts.length; ++i) {
            if (i - 1 >= 0 && i - 1 < this.parameters.length) {
                Validate.isTrue(this.assembleParameter(this.parameters[i - 1], queryBuilder), "UNKNOWN DataType :" + (this.parameters[i - 1] == null ? null : this.parameters[i - 1].getClass()));
            }
            queryBuilder.append(this.queryParts[i]);
        }
        return queryBuilder.toString();
    }

    private boolean assembleParameter(Object parameter, StringBuilder queryBuilder) throws SQLException {
        return this.assembleSimpleParameter(queryBuilder, parameter) || this.assembleComplexQuotedParameter(queryBuilder, parameter);
    }

    private boolean assembleSimpleParameter(StringBuilder queryBuilder, Object parameter) {
        if (parameter == null) {
            return this.assembleWithoutQuotedParameter(queryBuilder, "Null");
        }
        if (parameter instanceof Number) {
            return this.assembleWithoutQuotedParameter(queryBuilder, parameter);
        }
        if (parameter instanceof String) {
            return this.assembleQuotedParameter(queryBuilder, String.valueOf(parameter));
        }
        if (parameter instanceof LocalDate) {
            return this.assembleQuotedParameter(queryBuilder, this.dateFmt.format((LocalDate)parameter));
        }
        if (parameter instanceof LocalDateTime) {
            return this.assembleQuotedParameter(queryBuilder, this.timestampFmt.format((LocalDateTime)parameter));
        }
        if (parameter instanceof ZonedDateTime) {
            return this.assembleQuotedParameter(queryBuilder, this.timestampFmt.format((ZonedDateTime)parameter));
        }
        return false;
    }

    private boolean assembleQuotedParameter(StringBuilder queryBuilder, String parameter) {
        queryBuilder.append("'");
        queryBuilder.append(parameter.replaceAll("'", Matcher.quoteReplacement("\\'")));
        queryBuilder.append("'");
        return true;
    }

    private boolean assembleWithoutQuotedParameter(StringBuilder queryBuilder, Object parameter) {
        queryBuilder.append(parameter);
        return true;
    }

    private boolean assembleComplexQuotedParameter(StringBuilder queryBuilder, Object parameter) throws SQLException {
        if (parameter instanceof Array) {
            queryBuilder.append("[");
            Object[] arrayData = (Object[])((Array)parameter).getArray();
            for (int arrayIndex = 0; arrayIndex < arrayData.length; ++arrayIndex) {
                this.assembleParameter(arrayData[arrayIndex], queryBuilder);
                queryBuilder.append(arrayIndex == arrayData.length - 1 ? "]" : ",");
            }
            return true;
        }
        if (parameter instanceof Struct) {
            queryBuilder.append("(");
            Object[] structData = ((Struct)parameter).getAttributes();
            for (int structIndex = 0; structIndex < structData.length; ++structIndex) {
                this.assembleParameter(structData[structIndex], queryBuilder);
                queryBuilder.append(structIndex == structData.length - 1 ? ")" : ",");
            }
            return true;
        }
        return false;
    }
}

