/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.stream;

import com.github.housepower.jdbc.data.Block;
import com.github.housepower.jdbc.misc.SQLLexer;
import com.github.housepower.jdbc.misc.Validate;
import com.github.housepower.jdbc.stream.InputFormat;
import java.sql.SQLException;
import java.util.BitSet;

public class ValuesInputFormat
implements InputFormat {
    private final SQLLexer lexer;

    public ValuesInputFormat(int pos, String sql) {
        this.lexer = new SQLLexer(pos, sql);
    }

    @Override
    public void fillBlock(Block block) throws SQLException {
        BitSet constIdxFlags = new BitSet(block.columnCnt());
        while (true) {
            char nextChar = this.lexer.character();
            if (this.lexer.eof() || nextChar == ';') break;
            if (nextChar == ',') {
                nextChar = this.lexer.character();
            }
            Validate.isTrue(nextChar == '(');
            for (int columnIdx = 0; columnIdx < block.columnCnt(); ++columnIdx) {
                if (columnIdx > 0) {
                    Validate.isTrue(this.lexer.character() == ',');
                }
                constIdxFlags.set(columnIdx);
                block.setConstObject(columnIdx, block.getColumnByPosition(columnIdx).type().deserializeTextQuoted(this.lexer));
            }
            Validate.isTrue(this.lexer.character() == ')');
            block.appendRow();
        }
        for (int columnIdx = 0; columnIdx < block.columnCnt(); ++columnIdx) {
            if (!constIdxFlags.get(columnIdx)) continue;
            block.incPlaceholderIndexes(columnIdx);
        }
    }
}

