/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.data;

import com.github.housepower.data.AbstractColumn;
import com.github.housepower.data.ColumnFactory;
import com.github.housepower.data.ColumnWriterBuffer;
import com.github.housepower.data.IColumn;
import com.github.housepower.data.type.complex.DataTypeArray;
import com.github.housepower.jdbc.ClickHouseArray;
import com.github.housepower.serde.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ColumnArray
extends AbstractColumn {
    private final List<Long> offsets = new ArrayList<Long>();
    private final IColumn data;

    public ColumnArray(String name, DataTypeArray type, Object[] values) {
        super(name, type, values);
        this.data = ColumnFactory.createColumn(null, type.getElemDataType(), null);
    }

    @Override
    public void write(Object object) throws IOException, SQLException {
        Object[] arr = ((ClickHouseArray)object).getArray();
        this.offsets.add(this.offsets.isEmpty() ? (long)arr.length : this.offsets.get(this.offsets.size() - 1) + (long)arr.length);
        for (Object field : arr) {
            this.data.write(field);
        }
    }

    @Override
    public void flushToSerializer(BinarySerializer serializer, boolean immediate) throws SQLException, IOException {
        if (this.isExported()) {
            serializer.writeUTF8StringBinary(this.name);
            serializer.writeUTF8StringBinary(this.type.name());
        }
        this.flushOffsets(serializer);
        this.data.flushToSerializer(serializer, false);
        if (immediate) {
            this.buffer.writeTo(serializer);
        }
    }

    public void flushOffsets(BinarySerializer serializer) throws IOException {
        for (long offsetList : this.offsets) {
            serializer.writeLong(offsetList);
        }
    }

    @Override
    public void setColumnWriterBuffer(ColumnWriterBuffer buffer) {
        super.setColumnWriterBuffer(buffer);
        this.data.setColumnWriterBuffer(buffer);
    }

    @Override
    public void clear() {
        this.offsets.clear();
        this.data.clear();
    }
}

