/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.data.type.complex;

import com.github.housepower.data.DataTypeFactory;
import com.github.housepower.data.IDataType;
import com.github.housepower.data.type.DataTypeInt64;
import com.github.housepower.data.type.complex.DataTypeCreator;
import com.github.housepower.misc.SQLLexer;
import com.github.housepower.misc.Validate;
import com.github.housepower.serde.BinaryDeserializer;
import com.github.housepower.serde.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class DataTypeMap
implements IDataType<Object, Object> {
    public static DataTypeCreator<Object, Object> creator = (lexer, serverContext) -> {
        Validate.isTrue(lexer.character() == '(');
        IDataType<?, ?> key = DataTypeFactory.get(lexer, serverContext);
        Validate.isTrue(lexer.character() == ',');
        IDataType<?, ?> value = DataTypeFactory.get(lexer, serverContext);
        Validate.isTrue(lexer.character() == ')');
        IDataType[] nestedTypes = new IDataType[]{key, value};
        String name = "Map(" + key.name() + ", " + value.name() + ")";
        return new DataTypeMap(name, nestedTypes, (DataTypeInt64)DataTypeFactory.get("Int64", serverContext));
    };
    private final String name;
    private final IDataType<?, ?>[] nestedTypes;
    private final DataTypeInt64 offsetIDataType;

    public DataTypeMap(String name, IDataType<?, ?>[] nestedTypes, DataTypeInt64 offsetIDataType) {
        this.name = name;
        this.nestedTypes = nestedTypes;
        this.offsetIDataType = offsetIDataType;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Class<Object> javaType() {
        return Object.class;
    }

    @Override
    public int sqlTypeId() {
        return 2000;
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public void serializeBinary(Object data, BinarySerializer serializer) throws SQLException, IOException {
        if (data instanceof Map) {
            Map dataMap = (Map)data;
            this.getNestedTypes()[0].serializeBinaryBulk(dataMap.keySet().toArray(), serializer);
            this.getNestedTypes()[1].serializeBinaryBulk(dataMap.values().toArray(), serializer);
        }
    }

    @Override
    public void serializeBinaryBulk(Object[] data, BinarySerializer serializer) throws SQLException, IOException {
        Map dataMap;
        this.offsetIDataType.serializeBinary(Long.valueOf(data.length), serializer);
        for (Object obj : data) {
            if (!(obj instanceof Map)) continue;
            dataMap = (Map)obj;
            this.getNestedTypes()[0].serializeBinaryBulk(dataMap.keySet().toArray(), serializer);
        }
        for (Object obj : data) {
            if (!(obj instanceof Map)) continue;
            dataMap = (Map)obj;
            this.getNestedTypes()[1].serializeBinaryBulk(dataMap.values().toArray(), serializer);
        }
    }

    @Override
    public Object deserializeText(SQLLexer lexer) throws SQLException {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        Object key = null;
        Object value = null;
        Validate.isTrue(lexer.character() == '{');
        while (true) {
            if (lexer.isCharacter('}')) break;
            key = this.getNestedTypes()[0].deserializeText(lexer);
            Validate.isTrue(lexer.character() == ':');
            value = this.getNestedTypes()[1].deserializeText(lexer);
            if (lexer.isCharacter(',')) {
                lexer.character();
            }
            result.put(key, value);
        }
        lexer.character();
        return result;
    }

    @Override
    public Object deserializeBinary(BinaryDeserializer deserializer) throws SQLException, IOException {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        Long offset = this.offsetIDataType.deserializeBinary(deserializer);
        Object[] keys = this.getNestedTypes()[0].deserializeBinaryBulk(offset.intValue(), deserializer);
        Object[] values = this.getNestedTypes()[1].deserializeBinaryBulk(offset.intValue(), deserializer);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    @Override
    public Object[] deserializeBinaryBulk(int rows, BinaryDeserializer deserializer) throws IOException, SQLException {
        Object[] arrays = new Object[rows];
        if (rows == 0) {
            return arrays;
        }
        int[] offsets = Arrays.stream(this.offsetIDataType.deserializeBinaryBulk(rows, deserializer)).mapToInt(value -> ((Long)value).intValue()).toArray();
        Object[] keys = this.getNestedTypes()[0].deserializeBinaryBulk(offsets[rows - 1], deserializer);
        Object[] values = this.getNestedTypes()[1].deserializeBinaryBulk(offsets[rows - 1], deserializer);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        int lastOffset = 0;
        for (int row = 0; row < rows; ++row) {
            int offset = offsets[row];
            for (int i = lastOffset; i < offset; ++i) {
                map.put(keys[i], values[i]);
            }
            lastOffset = offset;
            arrays[row] = map;
            map = new HashMap();
        }
        return arrays;
    }

    public IDataType[] getNestedTypes() {
        return this.nestedTypes;
    }
}

