/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.misc;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class CollectionUtil {
    public static <T> List<T> concat(List<T> first, List<T> second) {
        return Stream.concat(first.stream(), second.stream()).collect(Collectors.toList());
    }

    @SafeVarargs
    public static <T> List<T> concat(List<T> originList, T ... elements) {
        return Stream.concat(originList.stream(), Stream.of(elements)).collect(Collectors.toList());
    }

    public static <T> List<T> repeat(int time, List<T> origin) {
        assert (time > 0);
        List<T> result = origin;
        for (int i = 0; i < time - 1; ++i) {
            result = CollectionUtil.concat(result, origin);
        }
        return result;
    }

    public static List<String> filterIgnoreCase(List<String> set, String keyword) {
        return set.stream().filter(key -> key.equalsIgnoreCase(keyword)).collect(Collectors.toList());
    }

    public static Map<String, String> filterKeyIgnoreCase(Properties properties, String keyword) {
        HashMap props = new HashMap();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> props.put(k.toString(), v.toString())));
        return CollectionUtil.filterKeyIgnoreCase(props, keyword);
    }

    public static <V> Map<String, V> filterKeyIgnoreCase(Map<String, V> map, String keyword) {
        return map.entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(keyword)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static <K, V> Map<K, V> mergeMapKeepFirst(Map<K, V> one, Map<K, V> other) {
        return Stream.concat(one.entrySet().stream(), other.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (former, latter) -> former));
    }

    public static <K, V> Map<K, V> mergeMapKeepLast(Map<K, V> one, Map<K, V> other) {
        return Stream.concat(one.entrySet().stream(), other.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (former, latter) -> latter));
    }

    public static <K, V> void mergeMapInPlaceKeepFirst(Map<K, V> one, @Nullable Map<K, V> other) {
        if (other != null) {
            other.forEach(one::putIfAbsent);
        }
    }

    public static <K, V> void mergeMapInPlaceKeepLast(Map<K, V> one, @Nullable Map<K, V> other) {
        if (other != null) {
            other.forEach(one::put);
        }
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return collection != null && collection.size() > 0;
    }
}

