/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.serde;

import com.github.housepower.buffer.BuffedReader;
import com.github.housepower.buffer.CompressedBuffedReader;
import com.github.housepower.misc.Switcher;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class BinaryDeserializer {
    private final Switcher<BuffedReader> switcher;
    private final boolean enableCompress;

    public BinaryDeserializer(BuffedReader buffedReader, boolean enableCompress) {
        this.enableCompress = enableCompress;
        CompressedBuffedReader compressedReader = null;
        if (enableCompress) {
            compressedReader = new CompressedBuffedReader(buffedReader);
        }
        this.switcher = new Switcher<BuffedReader>(compressedReader, buffedReader);
    }

    public long readVarInt() throws IOException {
        int number = 0;
        for (int i = 0; i < 9; ++i) {
            int byt = this.switcher.get().readBinary();
            number |= (byt & 0x7F) << 7 * i;
            if ((byt & 0x80) == 0) break;
        }
        return number;
    }

    public short readShort() throws IOException {
        return (short)(((this.switcher.get().readBinary() & 0xFF) << 0) + ((this.switcher.get().readBinary() & 0xFF) << 8));
    }

    public int readInt() throws IOException {
        return ((this.switcher.get().readBinary() & 0xFF) << 0) + ((this.switcher.get().readBinary() & 0xFF) << 8) + ((this.switcher.get().readBinary() & 0xFF) << 16) + ((this.switcher.get().readBinary() & 0xFF) << 24);
    }

    public long readLong() throws IOException {
        return (((long)this.switcher.get().readBinary() & 0xFFL) << 0) + (((long)this.switcher.get().readBinary() & 0xFFL) << 8) + (((long)this.switcher.get().readBinary() & 0xFFL) << 16) + (((long)this.switcher.get().readBinary() & 0xFFL) << 24) + (((long)this.switcher.get().readBinary() & 0xFFL) << 32) + (((long)this.switcher.get().readBinary() & 0xFFL) << 40) + (((long)this.switcher.get().readBinary() & 0xFFL) << 48) + (((long)this.switcher.get().readBinary() & 0xFFL) << 56);
    }

    public boolean readBoolean() throws IOException {
        return this.switcher.get().readBinary() != 0;
    }

    public byte[] readBytesBinary() throws IOException {
        byte[] data = new byte[(int)this.readVarInt()];
        this.switcher.get().readBinary(data);
        return data;
    }

    public String readUTF8StringBinary() throws IOException {
        byte[] data = new byte[(int)this.readVarInt()];
        return this.switcher.get().readBinary(data) > 0 ? new String(data, StandardCharsets.UTF_8) : "";
    }

    public byte readByte() throws IOException {
        return (byte)this.switcher.get().readBinary();
    }

    public void maybeEnableCompressed() {
        if (this.enableCompress) {
            this.switcher.select(false);
        }
    }

    public void maybeDisableCompressed() {
        if (this.enableCompress) {
            this.switcher.select(true);
        }
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(((this.switcher.get().readBinary() & 0xFF) << 0) + ((this.switcher.get().readBinary() & 0xFF) << 8) + ((this.switcher.get().readBinary() & 0xFF) << 16) + (this.switcher.get().readBinary() << 24));
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble((((long)this.switcher.get().readBinary() & 0xFFL) << 0) + (((long)this.switcher.get().readBinary() & 0xFFL) << 8) + (((long)this.switcher.get().readBinary() & 0xFFL) << 16) + (((long)this.switcher.get().readBinary() & 0xFFL) << 24) + (((long)this.switcher.get().readBinary() & 0xFFL) << 32) + (((long)this.switcher.get().readBinary() & 0xFFL) << 40) + (((long)this.switcher.get().readBinary() & 0xFFL) << 48) + (((long)this.switcher.get().readBinary() & 0xFFL) << 56));
    }

    public byte[] readBytes(int size) throws IOException {
        byte[] bytes = new byte[size];
        this.switcher.get().readBinary(bytes);
        return bytes;
    }
}

