/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.data.type;

import com.github.housepower.data.IDataType;
import com.github.housepower.misc.SQLLexer;
import com.github.housepower.serde.BinaryDeserializer;
import com.github.housepower.serde.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;

public class DataTypeIPv4
implements IDataType<Long, Long> {
    @Override
    public String name() {
        return "IPv4";
    }

    @Override
    public int sqlTypeId() {
        return 4;
    }

    @Override
    public Long defaultValue() {
        return 0L;
    }

    @Override
    public Class<Long> javaType() {
        return Long.class;
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public int getScale() {
        return 15;
    }

    @Override
    public void serializeBinary(Long data, BinarySerializer serializer) throws SQLException, IOException {
        serializer.writeInt(data.intValue());
    }

    @Override
    public Long deserializeBinary(BinaryDeserializer deserializer) throws SQLException, IOException {
        return (long)deserializer.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public String[] getAliases() {
        return new String[0];
    }

    @Override
    public Long deserializeText(SQLLexer lexer) throws SQLException {
        return lexer.numberLiteral().longValue() & 0xFFFFFFFFL;
    }
}

