/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.stream;

import com.github.housepower.data.Block;
import com.github.housepower.misc.SQLLexer;
import com.github.housepower.misc.Validate;
import com.github.housepower.stream.NativeInputFormat;
import java.sql.SQLException;
import java.util.BitSet;

public class ValuesWithParametersNativeInputFormat
implements NativeInputFormat {
    private final SQLLexer lexer;

    public ValuesWithParametersNativeInputFormat(int pos, String sql) {
        this.lexer = new SQLLexer(pos, sql);
    }

    @Override
    public void fill(Block block) throws SQLException {
        int columnIdx;
        BitSet constIdxFlags = new BitSet(block.columnCnt());
        char nextChar = this.lexer.character();
        Validate.isTrue(nextChar == '(');
        for (columnIdx = 0; columnIdx < block.columnCnt(); ++columnIdx) {
            if (columnIdx > 0) {
                Validate.isTrue(this.lexer.character() == ',');
            }
            if (this.lexer.isCharacter('?')) {
                this.lexer.character();
                continue;
            }
            constIdxFlags.set(columnIdx);
            block.setObject(columnIdx, block.getColumn(columnIdx).type().deserializeText(this.lexer));
        }
        for (columnIdx = 0; columnIdx < block.columnCnt(); ++columnIdx) {
            if (!constIdxFlags.get(columnIdx)) continue;
            block.incPlaceholderIndexes(columnIdx);
        }
        Validate.isTrue(this.lexer.character() == ')');
    }
}

