/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc;

import com.github.housepower.data.Block;
import com.github.housepower.data.IColumn;
import com.github.housepower.exception.ClickHouseSQLException;
import com.github.housepower.jdbc.ClickHouseResultSetMetaData;
import com.github.housepower.jdbc.statement.ClickHouseStatement;
import com.github.housepower.jdbc.wrapper.SQLResultSet;
import com.github.housepower.log.Logger;
import com.github.housepower.log.LoggerFactory;
import com.github.housepower.misc.CheckedIterator;
import com.github.housepower.misc.DateTimeUtil;
import com.github.housepower.misc.Validate;
import com.github.housepower.protocol.DataResponse;
import com.github.housepower.settings.ClickHouseConfig;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Calendar;

public class ClickHouseResultSet
implements SQLResultSet {
    private static final Logger LOG = LoggerFactory.getLogger(ClickHouseResultSet.class);
    private int currentRowNum = -1;
    private Block currentBlock = new Block();
    private int lastFetchRowIdx = -1;
    private int lastFetchColumnIdx = -1;
    private Block lastFetchBlock = null;
    private final ClickHouseStatement statement;
    private final ClickHouseConfig cfg;
    private final String db;
    private final String table;
    private final Block header;
    private final CheckedIterator<DataResponse, SQLException> dataResponses;
    private boolean isFirst = false;
    private boolean isAfterLast = false;
    private boolean isClosed = false;
    private long readRows = 0L;
    private long readBytes = 0L;

    public ClickHouseResultSet(ClickHouseStatement statement, ClickHouseConfig cfg, String db, String table, Block header, CheckedIterator<DataResponse, SQLException> dataResponses) {
        this.statement = statement;
        this.cfg = cfg;
        this.db = db;
        this.table = table;
        this.header = header;
        this.dataResponses = dataResponses;
    }

    @Override
    public boolean getBoolean(String name) throws SQLException {
        return this.getBoolean(this.findColumn(name));
    }

    @Override
    public byte getByte(String name) throws SQLException {
        return this.getByte(this.findColumn(name));
    }

    @Override
    public short getShort(String name) throws SQLException {
        return this.getShort(this.findColumn(name));
    }

    @Override
    public int getInt(String name) throws SQLException {
        return this.getInt(this.findColumn(name));
    }

    @Override
    public long getLong(String name) throws SQLException {
        return this.getLong(this.findColumn(name));
    }

    @Override
    public float getFloat(String name) throws SQLException {
        return this.getFloat(this.findColumn(name));
    }

    @Override
    public double getDouble(String name) throws SQLException {
        return this.getDouble(this.findColumn(name));
    }

    @Override
    public Timestamp getTimestamp(String name) throws SQLException {
        return this.getTimestamp(this.findColumn(name));
    }

    @Override
    public Timestamp getTimestamp(String name, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(name), cal);
    }

    @Override
    public Date getDate(String name) throws SQLException {
        return this.getDate(this.findColumn(name));
    }

    @Override
    public BigDecimal getBigDecimal(String name) throws SQLException {
        return this.getBigDecimal(this.findColumn(name));
    }

    @Override
    public String getString(String name) throws SQLException {
        return this.getString(this.findColumn(name));
    }

    @Override
    public byte[] getBytes(String name) throws SQLException {
        return this.getBytes(this.findColumn(name));
    }

    @Override
    public URL getURL(String name) throws SQLException {
        return this.getURL(this.findColumn(name));
    }

    public BigInteger getBigInteger(String columnName) throws SQLException {
        return this.getBigInteger(this.findColumn(columnName));
    }

    public BigInteger getBigInteger(int columnIndex) throws SQLException {
        Object valueObj = this.getObject(columnIndex);
        if (valueObj instanceof BigInteger) {
            return (BigInteger)valueObj;
        }
        if (this.wasNull()) {
            return null;
        }
        throw new SQLException("Column " + columnIndex + " is not of type BigInteger.");
    }

    @Override
    public Array getArray(String name) throws SQLException {
        return this.getArray(this.findColumn(name));
    }

    @Override
    public Object getObject(String name) throws SQLException {
        return this.getObject(this.findColumn(name));
    }

    @Override
    public boolean getBoolean(int position) throws SQLException {
        Object data = this.getInternalObject(position);
        if (data == null) {
            return false;
        }
        Number ndata = (Number)data;
        return ndata.shortValue() != 0;
    }

    @Override
    public byte getByte(int position) throws SQLException {
        Object data = this.getInternalObject(position);
        if (data == null) {
            return 0;
        }
        return ((Number)data).byteValue();
    }

    @Override
    public short getShort(int position) throws SQLException {
        Object data = this.getInternalObject(position);
        if (data == null) {
            return 0;
        }
        return ((Number)data).shortValue();
    }

    @Override
    public int getInt(int position) throws SQLException {
        Object data = this.getInternalObject(position);
        if (data == null) {
            return 0;
        }
        return ((Number)data).intValue();
    }

    @Override
    public long getLong(int position) throws SQLException {
        Object data = this.getInternalObject(position);
        if (data == null) {
            return 0L;
        }
        return ((Number)data).longValue();
    }

    @Override
    public float getFloat(int position) throws SQLException {
        Object data = this.getInternalObject(position);
        if (data == null) {
            return 0.0f;
        }
        return ((Number)data).floatValue();
    }

    @Override
    public double getDouble(int position) throws SQLException {
        Object data = this.getInternalObject(position);
        if (data == null) {
            return 0.0;
        }
        return ((Number)data).doubleValue();
    }

    @Override
    public Timestamp getTimestamp(int position) throws SQLException {
        Object data = this.getInternalObject(position);
        if (data == null) {
            return null;
        }
        ZonedDateTime zts = (ZonedDateTime)data;
        return DateTimeUtil.toTimestamp(zts, null);
    }

    @Override
    public Timestamp getTimestamp(int position, Calendar cal) throws SQLException {
        Object data = this.getInternalObject(position);
        if (data == null) {
            return null;
        }
        ZonedDateTime zts = (ZonedDateTime)data;
        return DateTimeUtil.toTimestamp(zts, cal.getTimeZone().toZoneId());
    }

    @Override
    public Date getDate(int position) throws SQLException {
        LocalDate date = (LocalDate)this.getInternalObject(position);
        if (date == null) {
            return null;
        }
        return Date.valueOf(date);
    }

    @Override
    public BigDecimal getBigDecimal(int position) throws SQLException {
        Object data = this.getInternalObject(position);
        if (data == null) {
            return null;
        }
        if (data instanceof BigDecimal) {
            return (BigDecimal)data;
        }
        return new BigDecimal(data.toString());
    }

    @Override
    public String getString(int position) throws SQLException {
        Object data = this.getInternalObject(position);
        if (data == null) {
            return null;
        }
        return data.toString();
    }

    @Override
    public byte[] getBytes(int position) throws SQLException {
        Object data = this.getInternalObject(position);
        if (data == null) {
            return null;
        }
        if (data instanceof String) {
            return ((String)data).getBytes(this.cfg.charset());
        }
        throw new ClickHouseSQLException(-1, "Currently not support getBytes from class: " + data.getClass());
    }

    @Override
    public URL getURL(int position) throws SQLException {
        String data = this.getString(position);
        if (data == null) {
            return null;
        }
        try {
            return new URL(data);
        }
        catch (MalformedURLException ex) {
            throw new SQLException(ex.getMessage(), ex);
        }
    }

    @Override
    public Array getArray(int position) throws SQLException {
        Object data = this.getInternalObject(position);
        return (Array)data;
    }

    @Override
    public Object getObject(int position) throws SQLException {
        Object obj = this.getInternalObject(position);
        if (obj == null) {
            return null;
        }
        if (obj instanceof ZonedDateTime) {
            return DateTimeUtil.toTimestamp((ZonedDateTime)obj, null);
        }
        if (obj instanceof LocalDate) {
            return Date.valueOf((LocalDate)obj);
        }
        return obj;
    }

    private Object getInternalObject(int position) throws SQLException {
        LOG.trace("get object at row: {}, column position: {} from block with column count: {}, row count: {}", this.currentRowNum, position, this.currentBlock.columnCnt(), this.currentBlock.rowCnt());
        Validate.isTrue(this.currentRowNum >= 0 && this.currentRowNum < this.currentBlock.rowCnt(), "No row information was obtained. You must call ResultSet.next() before that.");
        this.lastFetchBlock = this.currentBlock;
        this.lastFetchColumnIdx = position - 1;
        IColumn column = this.lastFetchBlock.getColumn(this.lastFetchColumnIdx);
        this.lastFetchRowIdx = this.currentRowNum;
        return column.value(this.lastFetchRowIdx);
    }

    @Override
    public boolean first() throws SQLException {
        throw new SQLException("TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean last() throws SQLException {
        throw new SQLException("TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.currentRowNum == -1;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.isFirst;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.isAfterLast;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new ClickHouseResultSetMetaData(this.header, this.db, this.table);
    }

    @Override
    public boolean wasNull() throws SQLException {
        Validate.isTrue(this.lastFetchBlock != null, "Please call Result.next()");
        Validate.isTrue(this.lastFetchColumnIdx >= 0, "Please call Result.getXXX()");
        Validate.isTrue(this.lastFetchRowIdx >= 0 && this.lastFetchRowIdx < this.lastFetchBlock.rowCnt(), "Please call Result.next()");
        return this.lastFetchBlock.getColumn(this.lastFetchColumnIdx).value(this.lastFetchRowIdx) == null;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public int findColumn(String name) throws SQLException {
        LOG.trace("find column: {}", name);
        return this.header.getPositionByName(name);
    }

    @Override
    public boolean next() throws SQLException {
        boolean hasNext;
        boolean isBeforeFirst = this.isBeforeFirst();
        LOG.trace("check status[before]: is_before_first: {}, is_first: {}, is_after_last: {}", isBeforeFirst, this.isFirst, this.isAfterLast);
        boolean bl = hasNext = ++this.currentRowNum < this.currentBlock.rowCnt();
        if (!hasNext) {
            this.currentRowNum = 0;
            this.currentBlock = this.fetchBlock();
            hasNext = 0 < this.currentBlock.rowCnt();
            this.readRows += this.currentBlock.readRows();
            this.readBytes += this.currentBlock.readBytes();
        }
        this.isFirst = isBeforeFirst && hasNext;
        this.isAfterLast = !hasNext;
        LOG.trace("check status[after]: has_next: {}, is_before_first: {}, is_first: {}, is_after_last: {}", hasNext, this.isBeforeFirst(), this.isFirst, this.isAfterLast);
        return hasNext;
    }

    @Override
    public void close() throws SQLException {
        LOG.debug("close ResultSet", new Object[0]);
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public Logger logger() {
        return LOG;
    }

    private Block fetchBlock() throws SQLException {
        long readRows = 0L;
        long readBytes = 0L;
        while (this.dataResponses.hasNext()) {
            LOG.trace("fetch next DataResponse", new Object[0]);
            DataResponse next = this.dataResponses.next();
            readRows += next.block().readRows();
            readBytes += next.block().readBytes();
            if (next.block().rowCnt() <= 0) continue;
            next.block().setProgress(readRows, readBytes);
            return next.block();
        }
        LOG.debug("no more DataResponse, return empty Block", new Object[0]);
        Block bk = new Block();
        bk.setProgress(readRows, readBytes);
        return bk;
    }

    public long getReadRows() {
        return this.readRows;
    }

    public long getReadBytes() {
        return this.readBytes;
    }
}

