/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.misc;

public class StringView
implements CharSequence {
    private final String str;
    private final int start;
    private final int end;
    private int hashVal;
    private String repr;

    public StringView(String str, int start, int end) {
        this.str = str;
        this.start = Math.max(start, 0);
        this.end = Math.min(end, str.length());
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    @Override
    public char charAt(int index) {
        return this.str.charAt(this.start + index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.subview(start, end);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StringView)) {
            return false;
        }
        StringView other = (StringView)obj;
        int len = this.length();
        if (len != other.length()) {
            return false;
        }
        int start1 = this.start;
        for (int start2 = other.start; start1 < this.end && start2 < other.end; ++start1, ++start2) {
            if (this.str.charAt(start1) == other.str.charAt(start2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashVal == 0) {
            int h = 16777619;
            for (int i = this.start; i < this.end; ++i) {
                h = 31 * h + this.str.charAt(i);
            }
            if (h == 0) {
                ++h;
            }
            this.hashVal = h;
        }
        return this.hashVal;
    }

    @Override
    public String toString() {
        return this.repr();
    }

    public String data() {
        return this.str;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public StringView subview(int start0, int end0) {
        return new StringView(this.str, this.start + start0, this.start + end0);
    }

    public String repr() {
        if (this.repr == null) {
            this.repr = this.str.substring(this.start, this.end);
        }
        return this.repr;
    }

    public boolean checkEquals(String expectString) {
        if (expectString == null || expectString.length() != this.end - this.start) {
            return false;
        }
        for (int i = 0; i < expectString.length(); ++i) {
            if (expectString.charAt(i) == this.str.charAt(this.start + i)) continue;
            return false;
        }
        return true;
    }

    public boolean checkEqualsIgnoreCase(String expectString) {
        if (expectString == null || expectString.length() != this.end - this.start) {
            return false;
        }
        for (int i = 0; i < expectString.length(); ++i) {
            if (expectString.charAt(i) == this.str.charAt(this.start + i)) continue;
            return false;
        }
        return true;
    }
}

