/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.protocol;

import com.github.housepower.protocol.Response;
import com.github.housepower.serde.BinaryDeserializer;
import java.io.IOException;

public class ProgressResponse
implements Response {
    private final long newRows;
    private final long newBytes;
    private final long newTotalRows;

    public static ProgressResponse readFrom(BinaryDeserializer deserializer) throws IOException {
        return new ProgressResponse(deserializer.readVarInt(), deserializer.readVarInt(), deserializer.readVarInt());
    }

    public ProgressResponse(long newRows, long newBytes, long newTotalRows) {
        this.newRows = newRows;
        this.newBytes = newBytes;
        this.newTotalRows = newTotalRows;
    }

    @Override
    public Response.ProtoType type() {
        return Response.ProtoType.RESPONSE_PROGRESS;
    }

    public long newRows() {
        return this.newRows;
    }

    public long newBytes() {
        return this.newBytes;
    }

    public long newTotalRows() {
        return this.newTotalRows;
    }

    public String toString() {
        return "ProgressResponse {newRows=" + this.newRows + ", newBytes=" + this.newBytes + ", newTotalRows=" + this.newTotalRows + '}';
    }
}

