/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.protocol;

import com.github.housepower.client.NativeContext;
import com.github.housepower.protocol.DataRequest;
import com.github.housepower.protocol.Request;
import com.github.housepower.serde.BinarySerializer;
import com.github.housepower.serde.SettingType;
import com.github.housepower.settings.SettingKey;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class QueryRequest
implements Request {
    public static final int STAGE_FETCH_COLUMNS = 0;
    public static final int STAGE_WITH_MERGEABLE_STATE = 1;
    public static final int STAGE_COMPLETE = 2;
    public static final int STAGE_WITH_MERGEABLE_STATE_AFTER_AGGREGATION = 3;
    private final int stage;
    private final String queryId;
    private final String queryString;
    private final boolean compression;
    private final NativeContext.ClientContext clientContext;
    private final Map<SettingKey, Serializable> settings;

    public QueryRequest(String queryId, NativeContext.ClientContext clientContext, int stage, boolean compression, String queryString) {
        this(queryId, clientContext, stage, compression, queryString, new HashMap<SettingKey, Serializable>());
    }

    public QueryRequest(String queryId, NativeContext.ClientContext clientContext, int stage, boolean compression, String queryString, Map<SettingKey, Serializable> settings) {
        this.stage = stage;
        this.queryId = queryId;
        this.settings = settings;
        this.clientContext = clientContext;
        this.compression = compression;
        this.queryString = queryString;
    }

    @Override
    public Request.ProtoType type() {
        return Request.ProtoType.REQUEST_QUERY;
    }

    @Override
    public void writeImpl(BinarySerializer serializer) throws IOException, SQLException {
        serializer.writeUTF8StringBinary(this.queryId);
        this.clientContext.writeTo(serializer);
        for (Map.Entry<SettingKey, Serializable> entry : this.settings.entrySet()) {
            serializer.writeUTF8StringBinary(entry.getKey().name());
            SettingType<?> type = entry.getKey().type();
            type.serializeSetting(serializer, entry.getValue());
        }
        serializer.writeUTF8StringBinary("");
        serializer.writeVarInt(this.stage);
        serializer.writeBoolean(this.compression);
        serializer.writeUTF8StringBinary(this.queryString);
        DataRequest.EMPTY.writeTo(serializer);
    }
}

