/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class BatchQuery {
    public static void main(String[] args) throws Exception {
        try (Connection connection = DriverManager.getConnection("jdbc:clickhouse://127.0.0.1:9000");
             Statement stmt = connection.createStatement();){
            try (ResultSet rs = stmt.executeQuery("drop table if exists test_jdbc_example");){
                System.out.println(rs.next());
            }
            rs = stmt.executeQuery("create table test_jdbc_example(day Date, name String, age UInt8) Engine=Log");
            var6_10 = null;
            try {
                System.out.println(rs.next());
            }
            catch (Throwable throwable) {
                var6_10 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var6_10 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var6_10.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
            var6_10 = null;
            try (PreparedStatement pstmt = connection.prepareStatement("INSERT INTO test_jdbc_example VALUES(?, ?, ?)");){
                for (int i = 1; i <= 200; ++i) {
                    pstmt.setDate(1, new Date(System.currentTimeMillis()));
                    if (i % 2 == 0) {
                        pstmt.setString(2, "Zhang San" + i);
                    } else {
                        pstmt.setString(2, "Zhang San");
                    }
                    pstmt.setByte(3, (byte)(i % 4 * 15));
                    System.out.println(pstmt);
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
            catch (Throwable throwable) {
                var6_10 = throwable;
                throw throwable;
            }
            pstmt = connection.prepareStatement("select count(*) from test_jdbc_example where age>? and age<=?");
            var6_10 = null;
            try {
                pstmt.setByte(1, (byte)10);
                pstmt.setByte(2, (byte)30);
                BatchQuery.printCount(pstmt);
            }
            catch (Throwable throwable) {
                var6_10 = throwable;
                throw throwable;
            }
            finally {
                if (pstmt != null) {
                    if (var6_10 != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable) {
                            var6_10.addSuppressed(throwable);
                        }
                    } else {
                        pstmt.close();
                    }
                }
            }
            pstmt = connection.prepareStatement("select count(*) from test_jdbc_example where name=?");
            var6_10 = null;
            try {
                pstmt.setString(1, "Zhang San");
                BatchQuery.printCount(pstmt);
            }
            catch (Throwable throwable) {
                var6_10 = throwable;
                throw throwable;
            }
            finally {
                if (pstmt != null) {
                    if (var6_10 != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable) {
                            var6_10.addSuppressed(throwable);
                        }
                    } else {
                        pstmt.close();
                    }
                }
            }
            rs = stmt.executeQuery("drop table test_jdbc_example");
            var6_10 = null;
            try {
                System.out.println(rs.next());
            }
            catch (Throwable throwable) {
                var6_10 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var6_10 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var6_10.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
    }

    public static void printCount(PreparedStatement pstmt) throws SQLException {
        try (ResultSet rs = pstmt.executeQuery();){
            System.out.println(pstmt);
            if (rs.next()) {
                System.out.println(rs.getInt(1));
            }
        }
    }
}

