/*
 * Decompiled with CFR 0.152.
 */
package com.hroniko.weblog.weblogger.aspects;

import com.hroniko.weblog.weblogger.annotations.RestLog;
import com.hroniko.weblog.weblogger.aspects.RestLogProducer;
import com.hroniko.weblog.weblogger.entities.RestLogContainer;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
public class RestLogAspect {
    private RestLogProducer logProducer = new RestLogProducer();
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ RestLogAspect ajc$perSingletonInstance;

    @AfterReturning(value="execution(@com.hroniko.weblogger.annotations.RestLog * *(..))", returning="result")
    public void interceptRestLog(JoinPoint joinPoint, Object result) throws Throwable {
        this.restLogLogic(joinPoint, result, null);
    }

    @AfterThrowing(value="execution(@com.hroniko.weblogger.annotations.RestLog * *(..))", throwing="exception")
    public void afterThrowingAdvice(JoinPoint joinPoint, Throwable exception) throws Throwable {
        this.restLogLogic(joinPoint, null, exception);
    }

    private void restLogLogic(JoinPoint joinPoint, Object result, Throwable exception) throws Throwable {
        Signature signature = joinPoint.getSignature();
        if (signature instanceof MethodSignature) {
            Method method = ((MethodSignature)signature).getMethod();
            RestLog restLog = (RestLog)AnnotationUtils.findAnnotation((Method)method, RestLog.class);
            if (restLog == null) {
                restLog = (RestLog)AnnotationUtils.findAnnotation(method.getDeclaringClass(), RestLog.class);
            }
            String logFile = restLog.logFile();
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
            HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getResponse();
            this.logProducer.log(new RestLogContainer(joinPoint, result, logFile, restLog.ignoreParams(), request, response, exception));
        }
    }

    public static RestLogAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.hroniko.weblog.weblogger.aspects.RestLogAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            RestLogAspect.ajc$perSingletonInstance = new RestLogAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

