/*
 * Decompiled with CFR 0.152.
 */
package com.hroniko.weblog.weblogger.aspects;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.hroniko.weblog.persistence.FileSaver;
import com.hroniko.weblog.weblogger.entities.RestLogContainer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;

public class RestLogProducer {
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
    private static final ImmutableList<String> httpCrudOperations = ImmutableList.builder().add((Object[])new String[]{"GET", "HEAD", "POST", "PUT", "DELETE", "CONNECT", "OPTIONS", "TRACE", "PATCH"}).build();
    private static final String[] IP_HEADER_CANDIDATES = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_X_FORWARDED_FOR", "HTTP_X_FORWARDED", "HTTP_X_CLUSTER_CLIENT_IP", "HTTP_CLIENT_IP", "HTTP_FORWARDED_FOR", "HTTP_FORWARDED", "HTTP_VIA", "REMOTE_ADDR"};

    public void log(RestLogContainer container) {
        JoinPoint joinPoint = container.getJoinPoint();
        Object result = container.getResult();
        String logFile = container.getLogFile();
        int[] ignoreParams = container.getIgnoreParams();
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        Class targetClass = joinPoint.getSignature().getDeclaringType();
        Object[] args = joinPoint.getArgs();
        Annotation[] methodAnnotations = method.getAnnotations();
        String restType = Arrays.stream(methodAnnotations).map(Annotation::annotationType).filter(Objects::nonNull).map(Class::getSimpleName).map(String::toUpperCase).map(annotationName -> {
            for (String httpCrudOperation : httpCrudOperations) {
                if (!annotationName.contains(httpCrudOperation)) continue;
                return httpCrudOperation;
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElse("<EMPTY>");
        String pathByClass = "";
        List partPathByClass = Optional.ofNullable(method.getDeclaringClass()).map(x -> x.getAnnotation(RequestMapping.class)).map(RequestMapping::value).map(stringArray -> Arrays.asList(stringArray)).get();
        if (!partPathByClass.isEmpty()) {
            pathByClass = partPathByClass.stream().collect(Collectors.joining());
        }
        String pathByMethod = "";
        List partPathByMethod = Optional.of(method).map(x -> x.getAnnotation(GetMapping.class)).map(GetMapping::value).map(stringArray -> Arrays.asList(stringArray)).get();
        if (partPathByMethod.isEmpty()) {
            partPathByMethod = Optional.of(method).map(x -> x.getAnnotation(PostMapping.class)).map(PostMapping::value).map(stringArray -> Arrays.asList(stringArray)).get();
        }
        if (partPathByMethod.isEmpty()) {
            partPathByMethod = Optional.of(method).map(x -> x.getAnnotation(PatchMapping.class)).map(PatchMapping::value).map(stringArray -> Arrays.asList(stringArray)).get();
        }
        if (partPathByMethod.isEmpty()) {
            partPathByMethod = Optional.of(method).map(x -> x.getAnnotation(PutMapping.class)).map(PutMapping::value).map(stringArray -> Arrays.asList(stringArray)).get();
        }
        if (partPathByMethod.isEmpty()) {
            partPathByMethod = Optional.of(method).map(x -> x.getAnnotation(DeleteMapping.class)).map(DeleteMapping::value).map(stringArray -> Arrays.asList(stringArray)).get();
        }
        if (!partPathByMethod.isEmpty()) {
            pathByMethod = partPathByMethod.stream().collect(Collectors.joining());
        }
        String fullPath = String.valueOf(pathByClass) + pathByMethod;
        HttpServletRequest request = container.getRequest();
        HttpServletResponse response = container.getResponse();
        Throwable exception = container.getException();
        String message = this.createMessage(restType, fullPath, targetClass, method, args, ignoreParams, result, request, response, exception);
        FileSaver.writeToFS(logFile, message);
    }

    private String createMessage(String restType, String fullPath, Class targetClass, Method method, Object[] args, int[] ignoreParams, Object result, HttpServletRequest request, HttpServletResponse response, Throwable exception) {
        return this.createMessage(new Date(), restType, fullPath, targetClass, method, args, ignoreParams, result, request, response, exception);
    }

    private String createMessage(Date date, String restType, String fullPath, Class targetClass, Method method, Object[] args, int[] ignoreParams, Object result, HttpServletRequest request, HttpServletResponse response, Throwable exception) {
        StringBuffer log = new StringBuffer();
        String separator = "\t";
        log.append(dateFormatter.format(date)).append(separator).append(restType).append(separator);
        if (exception == null) {
            log.append(200);
        } else {
            log.append(500);
        }
        log.append(separator);
        if (request != null) {
            log.append(RestLogProducer.getUri(request));
        } else {
            log.append(fullPath);
        }
        log.append(separator);
        log.append(targetClass.getName()).append("#").append(method.getName()).append(Arrays.stream(method.getParameters()).map(x -> String.valueOf(x.getType().getSimpleName()) + " " + x.getName()).map(x -> x.replace("class ", "").replace("interface ", "")).collect(Collectors.joining(", ", "(", ")"))).append(separator);
        log.append("INPUT ");
        if (args.length == 0 || args.length == 1 && request != null || args.length == 1 && response != null || args.length == 2 && request != null && response != null) {
            log.append("<NONE> ");
        } else {
            Stream pair = Streams.zip(Arrays.stream(method.getParameters()), Arrays.stream(args), Pair::of);
            Stream<Integer> iterate = Stream.iterate(0, i -> i + 1).limit(args.length);
            Stream triple = Streams.zip((Stream)pair, iterate, (x, y) -> Triple.of((Object)((Parameter)x.getKey()), (Object)x.getValue(), (Object)y));
            ToStringStyle jsonStyle = ToStringStyle.JSON_STYLE;
            for (Triple paramTriple : triple.collect(Collectors.toList())) {
                Object arg;
                Parameter parameter = (Parameter)paramTriple.getLeft();
                String paramName = parameter.isNamePresent() ? parameter.getName() : parameter.getType().getName();
                Object rawValue = paramTriple.getMiddle();
                int i2 = (Integer)paramTriple.getRight();
                Object object = ArrayUtils.contains((int[])ignoreParams, (int)i2) ? (rawValue == null ? null : "<IGNORED>") : (arg = rawValue);
                if (arg instanceof HttpServletRequest || arg instanceof HttpServletResponse) continue;
                jsonStyle.append(log, paramName, arg, Boolean.valueOf(true));
            }
        }
        log.append(separator);
        Triple<String, String, String> clientHostInfo = RestLogProducer.getClientHostInfo(request);
        log.append("CLIENT ");
        log.append((String)clientHostInfo.getLeft());
        log.append(" | ");
        log.append((String)clientHostInfo.getMiddle());
        log.append(separator);
        log.append("OUTPUT ");
        if (result != null) {
            Stream.of(ToStringStyle.JSON_STYLE).forEach(style -> style.append(log, result.getClass().getSimpleName(), result, Boolean.valueOf(true)));
        } else {
            log.append("<NONE> ");
        }
        log.append(separator);
        log.append("ERROR ");
        if (exception != null) {
            Stream.of(ToStringStyle.JSON_STYLE).forEach(style -> style.append(log, "exception", (Object)ExceptionUtils.getStackTrace((Throwable)exception), Boolean.valueOf(true)));
        } else {
            log.append("<NONE> ");
        }
        return log.toString();
    }

    public static String getClientIpAddress(HttpServletRequest request) {
        String cIp = null;
        String[] stringArray = IP_HEADER_CANDIDATES;
        int n = IP_HEADER_CANDIDATES.length;
        int n2 = 0;
        while (n2 < n) {
            String header = stringArray[n2];
            String ip = request.getHeader(header);
            if (ip != null && ip.length() != 0 && !"unknown".equalsIgnoreCase(ip)) {
                cIp = ip;
                break;
            }
            ++n2;
        }
        if (cIp == null) {
            cIp = request.getRemoteAddr();
        }
        if (cIp == null) {
            return "127.0.0.1";
        }
        if (cIp.equals("0:0:0:0:0:0:0:1")) {
            return "127.0.0.1";
        }
        return cIp;
    }

    public static String getClientHost(HttpServletRequest request) {
        String host = request.getRemoteHost();
        if (host.equals("0:0:0:0:0:0:0:1") || host.equals("127.0.0.1")) {
            return "localhost";
        }
        return host;
    }

    public static Triple<String, String, String> getClientHostInfo(HttpServletRequest request) {
        if (request == null) {
            return Triple.of((Object)"<NONE>", (Object)"<NONE>", (Object)"<NONE>");
        }
        String hostName = null;
        String hostIp = null;
        String hostPort = null;
        String host = request.getHeader("host");
        if (host != null) {
            String[] partHost = host.split(":");
            if (partHost.length == 0) {
                host = null;
            }
            if (partHost.length > 0) {
                String tmp = partHost[0];
                if (Pattern.matches("([0-9]*[.:])*[0-9]+", tmp)) {
                    hostIp = tmp;
                } else {
                    hostName = tmp;
                }
                if (partHost.length > 1) {
                    hostPort = partHost[1];
                }
            }
        }
        if (hostName == null && hostIp != null) {
            hostName = hostIp.equals("127.0.0.1") || hostIp.equals("0.0.0.0") ? "localhost" : RestLogProducer.getClientHost(request);
        }
        if (hostName != null && hostIp == null) {
            hostIp = hostName.equals("localhost") ? "127.0.0.1" : RestLogProducer.getClientIpAddress(request);
        }
        if (hostName != null && hostIp != null) {
            hostName = RestLogProducer.getClientHost(request);
            hostIp = RestLogProducer.getClientIpAddress(request);
        }
        if (hostPort == null) {
            hostPort = "80";
        }
        return Triple.of((Object)hostName, (Object)hostIp, (Object)hostPort);
    }

    public static String getUri(HttpServletRequest request) {
        return String.valueOf(request.getScheme()) + "://" + request.getServerName() + ("http".equals(request.getScheme()) && request.getServerPort() == 80 || "https".equals(request.getScheme()) && request.getServerPort() == 443 ? "" : ":" + request.getServerPort()) + request.getRequestURI() + (request.getQueryString() != null ? "?" + request.getQueryString() : "");
    }
}

