/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompressionUtil.class);

    private CompressionUtil() {
    }

    public static File extractFileGzip(String _compressedFile, String _outputFileName) {
        return CompressionUtil.decompress(CompressionMethod.GZIP, _compressedFile, _outputFileName);
    }

    public static File compressFileGzip(String _sourceFile, String _outputFileName) {
        return CompressionUtil.compress(CompressionMethod.GZIP, _sourceFile, _outputFileName);
    }

    public static File decompress(CompressionMethod _method, String _compressedFile, String _outputFileName) {
        if (_method == null || _compressedFile == null) {
            return null;
        }
        File inputFile = new File(_compressedFile);
        if (!inputFile.exists()) {
            return null;
        }
        try {
            Constructor<? extends InputStream> constructor = _method.getInputStreamClass().getConstructor(InputStream.class);
            if (constructor != null) {
                InputStream inputStream = constructor.newInstance(new FileInputStream(inputFile));
                Path destPath = Paths.get(_outputFileName, new String[0]);
                Files.copy(inputStream, destPath, StandardCopyOption.REPLACE_EXISTING);
                return destPath.toFile();
            }
        }
        catch (IOException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException iOException) {
            LOGGER.error("Cannot uncompress file: ", (Throwable)iOException);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File compress(CompressionMethod _method, String _sourceFile, String _outputFileName) {
        if (_method == null) return null;
        if (_sourceFile == null) {
            return null;
        }
        File inputFile = new File(_sourceFile);
        if (!inputFile.exists()) {
            return null;
        }
        byte[] buffer = new byte[1024];
        try {
            Constructor<? extends DeflaterOutputStream> constructor = _method.getOutputStreamClass().getConstructor(OutputStream.class);
            if (constructor == null) return null;
            DeflaterOutputStream compressOutputStream = constructor.newInstance(new FileOutputStream(_outputFileName));
            try (FileInputStream in = new FileInputStream(_sourceFile);){
                int len;
                while ((len = in.read(buffer)) > 0) {
                    compressOutputStream.write(buffer, 0, len);
                }
                in.close();
                compressOutputStream.finish();
                compressOutputStream.close();
                File file = new File(_outputFileName);
                return file;
            }
        }
        catch (IOException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException _ex) {
            LOGGER.error("Cannot uncompress file: ", (Throwable)_ex);
        }
        return null;
    }

    public static enum CompressionMethod {
        GZIP(GZIPInputStream.class, GZIPOutputStream.class);

        private final Class<? extends InputStream> inputStreamClass;
        private final Class<? extends DeflaterOutputStream> outputStreamClass;

        private CompressionMethod(Class<? extends InputStream> _inputStreamClass, Class<? extends DeflaterOutputStream> _outputStreamClass) {
            this.inputStreamClass = _inputStreamClass;
            this.outputStreamClass = _outputStreamClass;
        }

        public Class<? extends InputStream> getInputStreamClass() {
            return this.inputStreamClass;
        }

        public Class<? extends DeflaterOutputStream> getOutputStreamClass() {
            return this.outputStreamClass;
        }
    }
}

