/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections.impl;

import com.github.hypfvieh.util.StringUtil;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.freedesktop.Hexdump;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.RemoteInvocationHandler;
import org.freedesktop.dbus.RemoteObject;
import org.freedesktop.dbus.SignalTuple;
import org.freedesktop.dbus.connections.AbstractConnection;
import org.freedesktop.dbus.connections.FreeBSDHelper;
import org.freedesktop.dbus.connections.transports.TransportFactory;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.interfaces.Introspectable;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.ExportedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectConnection
extends AbstractConnection {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String machineId = this.createMachineId();

    public DirectConnection(String address) throws DBusException {
        this(address, 100000);
    }

    public DirectConnection(String address, int timeout) throws DBusException {
        super(address, timeout);
        if (!this.getAddress().isServer()) {
            super.listen();
        }
    }

    @Override
    public void listen() {
        if (this.getAddress().isServer()) {
            super.listen();
        }
    }

    private String createMachineId() {
        try {
            String ascii = Hexdump.toAscii(MessageDigest.getInstance("MD5").digest(InetAddress.getLocalHost().getHostName().getBytes()));
            return ascii;
        }
        catch (UnknownHostException | NoSuchAlgorithmException exception) {
            return StringUtil.randomString(32);
        }
    }

    public static String createDynamicTCPSession() {
        int port;
        String address = "tcp:host=localhost";
        try {
            ServerSocket s = new ServerSocket();
            s.bind(null);
            port = s.getLocalPort();
            s.close();
        }
        catch (Exception e) {
            Random r = new Random();
            port = 32768 + Math.abs(r.nextInt()) % 28232;
        }
        address = address + ",port=" + port;
        address = address + ",guid=" + TransportFactory.genGUID();
        LoggerFactory.getLogger(DirectConnection.class).debug("Created Session address: {}", (Object)address);
        return address;
    }

    public static String createDynamicSession() {
        String address = "unix:";
        String path = "/tmp/dbus-XXXXXXXXXX";
        Random r = new Random();
        do {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < 10; ++i) {
                sb.append((char)(Math.abs(r.nextInt()) % 26 + 65));
            }
            path = path.replaceAll("..........$", sb.toString());
            LoggerFactory.getLogger(DirectConnection.class).trace("Trying path {}", (Object)path);
        } while (new File(path).exists());
        address = FreeBSDHelper.isFreeBSD() ? address + "path=" + path : address + "abstract=" + path;
        address = address + ",guid=" + TransportFactory.genGUID();
        LoggerFactory.getLogger(DirectConnection.class).debug("Created Session address: {}", (Object)address);
        return address;
    }

    DBusInterface dynamicProxy(String path) throws DBusException {
        try {
            Introspectable intro = this.getRemoteObject(path, Introspectable.class);
            String data = intro.Introspect();
            String[] tags = data.split("[<>]");
            ArrayList<String> ifaces = new ArrayList<String>();
            for (String tag : tags) {
                if (!tag.startsWith("interface")) continue;
                ifaces.add(tag.replaceAll("^interface *name *= *['\"]([^'\"]*)['\"].*$", "$1"));
            }
            ArrayList ifcs = new ArrayList();
            block5: for (String iface : ifaces) {
                int j = 0;
                while (j >= 0) {
                    try {
                        ifcs.add(Class.forName(iface));
                        continue block5;
                    }
                    catch (Exception exception) {
                        j = iface.lastIndexOf(".");
                        char[] cs = iface.toCharArray();
                        if (j < 0) continue;
                        cs[j] = 36;
                        iface = String.valueOf(cs);
                    }
                }
            }
            if (ifcs.size() == 0) {
                throw new DBusException("Could not find an interface to cast to");
            }
            RemoteObject ro = new RemoteObject(null, path, null, false);
            DBusInterface newi = (DBusInterface)Proxy.newProxyInstance(((Class)ifcs.get(0)).getClassLoader(), ifcs.toArray(new Class[0]), (InvocationHandler)new RemoteInvocationHandler(this, ro));
            this.getImportedObjects().put(newi, ro);
            return newi;
        }
        catch (Exception e) {
            this.logger.debug("", (Throwable)e);
            throw new DBusException(String.format("Failed to create proxy object for %s; reason: %s.", path, e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DBusInterface getExportedObject(String path) throws DBusException {
        ExportedObject o = null;
        Map<String, ExportedObject> map = this.getExportedObjects();
        synchronized (map) {
            o = this.getExportedObjects().get(path);
        }
        if (null != o && null == o.getObject().get()) {
            this.unExportObject(path);
            o = null;
        }
        if (null != o) {
            return o.getObject().get();
        }
        return this.dynamicProxy(path);
    }

    public DBusInterface getRemoteObject(String objectpath) throws DBusException {
        if (null == objectpath) {
            throw new DBusException("Invalid object path: null");
        }
        if (!objectpath.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$") || objectpath.length() > 255) {
            throw new DBusException("Invalid object path: " + objectpath);
        }
        return this.dynamicProxy(objectpath);
    }

    public <T extends DBusInterface> T getRemoteObject(String objectpath, Class<T> type) throws DBusException {
        if (null == objectpath) {
            throw new DBusException("Invalid object path: null");
        }
        if (null == type) {
            throw new ClassCastException("Not A DBus Interface");
        }
        if (!objectpath.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$") || objectpath.length() > 255) {
            throw new DBusException("Invalid object path: " + objectpath);
        }
        if (!DBusInterface.class.isAssignableFrom(type)) {
            throw new ClassCastException("Not A DBus Interface");
        }
        if (type.getName().equals(type.getSimpleName())) {
            throw new DBusException("DBusInterfaces cannot be declared outside a package");
        }
        RemoteObject ro = new RemoteObject(null, objectpath, type, false);
        DBusInterface i = (DBusInterface)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new RemoteInvocationHandler(this, ro));
        this.getImportedObjects().put(i, ro);
        return (T)i;
    }

    @Override
    protected <T extends DBusSignal> void removeSigHandler(DBusMatchRule rule, DBusSigHandler<T> handler) throws DBusException {
        SignalTuple key = new SignalTuple(rule.getInterface(), rule.getMember(), rule.getObject(), rule.getSource());
        Queue<DBusSigHandler<? extends DBusSignal>> v = this.getHandledSignals().get(key);
        if (null != v) {
            v.remove(handler);
            if (0 == v.size()) {
                this.getHandledSignals().remove(key);
            }
        }
    }

    @Override
    protected <T extends DBusSignal> void addSigHandler(DBusMatchRule rule, DBusSigHandler<T> handler) throws DBusException {
        SignalTuple key = new SignalTuple(rule.getInterface(), rule.getMember(), rule.getObject(), rule.getSource());
        Queue v = this.getHandledSignals().computeIfAbsent(key, val -> {
            ConcurrentLinkedQueue l = new ConcurrentLinkedQueue();
            return l;
        });
        v.add(handler);
    }

    @Override
    protected void removeGenericSigHandler(DBusMatchRule rule, DBusSigHandler<DBusSignal> handler) throws DBusException {
        SignalTuple key = new SignalTuple(rule.getInterface(), rule.getMember(), rule.getObject(), rule.getSource());
        Queue<DBusSigHandler<DBusSignal>> v = this.getGenericHandledSignals().get(key);
        if (null != v) {
            v.remove(handler);
            if (0 == v.size()) {
                this.getGenericHandledSignals().remove(key);
            }
        }
    }

    @Override
    protected void addGenericSigHandler(DBusMatchRule rule, DBusSigHandler<DBusSignal> handler) throws DBusException {
        SignalTuple key = new SignalTuple(rule.getInterface(), rule.getMember(), rule.getObject(), rule.getSource());
        Queue v = this.getGenericHandledSignals().computeIfAbsent(key, val -> {
            ConcurrentLinkedQueue l = new ConcurrentLinkedQueue();
            return l;
        });
        v.add(handler);
    }

    @Override
    public DBusInterface getExportedObject(String source, String path) throws DBusException {
        return this.getExportedObject(path);
    }

    @Override
    public String getMachineId() {
        return this.machineId;
    }
}

