/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.system;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class NativeLibraryLoader {
    private static final NativeLibraryLoader INSTANCE = new NativeLibraryLoader();
    private boolean enabled = true;

    private NativeLibraryLoader() {
    }

    public static boolean isEnabled() {
        return NativeLibraryLoader.INSTANCE.enabled;
    }

    public static void setEnabled(boolean _enabled) {
        NativeLibraryLoader.INSTANCE.enabled = _enabled;
    }

    public static void loadLibrary(boolean _trySystemLibsFirst, String _libName, String ... _searchPathes) {
        if (!NativeLibraryLoader.isEnabled()) {
            return;
        }
        if (_trySystemLibsFirst) {
            // empty if block
        }
        if (_searchPathes != null && _searchPathes.length > 0) {
            INSTANCE.findProperNativeLib(!_trySystemLibsFirst, _libName, Arrays.asList(_searchPathes));
        }
    }

    private void findProperNativeLib(boolean _trySystemLibToo, String _libName, List<String> _searchPathes) {
        Throwable throwable;
        String arch = System.getProperty("os.arch");
        for (String string : _searchPathes) {
            File file = new File(NativeLibraryLoader.concatFilePath(false, string, arch, _libName));
            if (!file.exists()) {
                file = new File(NativeLibraryLoader.concatFilePath(false, string, _libName));
            }
            if (this.loadLib(file.getAbsolutePath()) != null) continue;
            return;
        }
        Throwable loadLibError = null;
        for (String path : _searchPathes) {
            String fileNameWithPath = NativeLibraryLoader.concatFilePath(false, path, arch, _libName);
            InputStream libAsStream = NativeLibraryLoader.class.getClassLoader().getResourceAsStream(fileNameWithPath);
            if (libAsStream == null) {
                fileNameWithPath = NativeLibraryLoader.concatFilePath(false, path, _libName);
                libAsStream = NativeLibraryLoader.class.getClassLoader().getResourceAsStream(fileNameWithPath);
            }
            if (libAsStream == null) continue;
            String fileExt = NativeLibraryLoader.getFileExtension(fileNameWithPath);
            String prefix = fileNameWithPath.replace(new File(fileNameWithPath).getParent(), "").replace("." + fileExt, "");
            try {
                File tmpFile = this.extractToTemp(libAsStream, prefix, fileExt);
                loadLibError = this.loadLib(tmpFile.getAbsolutePath());
                if (loadLibError != null) continue;
                return;
            }
            catch (IOException iOException) {
            }
        }
        if (_trySystemLibToo && (throwable = this.loadSystemLib(_libName)) != null) {
            throw new RuntimeException(throwable);
        }
    }

    private Throwable loadLib(String _lib) {
        try {
            System.load(_lib);
            return null;
        }
        catch (Throwable _ex) {
            return _ex;
        }
    }

    private Throwable loadSystemLib(String _libName) {
        ArrayList<String> possibleNames = new ArrayList<String>();
        String fileExtension = NativeLibraryLoader.getFileExtension(_libName);
        String fileWithoutExt = null;
        if (fileExtension != null && !fileExtension.isEmpty()) {
            fileWithoutExt = _libName.replace("." + fileExtension, "");
            possibleNames.add(_libName.replace("." + fileExtension, ""));
        }
        if (_libName.startsWith("lib")) {
            if (fileWithoutExt != null) {
                possibleNames.add(fileWithoutExt.replaceFirst("^lib", ""));
            }
            possibleNames.add(_libName.replaceFirst("^lib", ""));
        }
        Throwable lastError = null;
        for (String name : possibleNames) {
            try {
                System.loadLibrary(name);
                return null;
            }
            catch (Throwable _ex) {
                lastError = _ex;
            }
        }
        return lastError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File extractToTemp(InputStream _fileToExtract, String _tmpName, String _fileSuffix) throws IOException {
        if (_fileToExtract == null) {
            throw new IOException("Null stream");
        }
        File tempFile = File.createTempFile(_tmpName, _fileSuffix);
        tempFile.deleteOnExit();
        if (!tempFile.exists()) {
            throw new FileNotFoundException("File " + tempFile.getAbsolutePath() + " could not be created");
        }
        byte[] buffer = new byte[1024];
        FileOutputStream os = new FileOutputStream(tempFile);
        try {
            int readBytes;
            while ((readBytes = _fileToExtract.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, readBytes);
            }
        }
        finally {
            ((OutputStream)os).close();
            _fileToExtract.close();
        }
        return tempFile;
    }

    public static String concatFilePath(boolean _includeTrailingDelimiter, String ... _parts) {
        if (_parts == null) {
            return null;
        }
        StringBuilder allParts = new StringBuilder();
        for (int i = 0; i < _parts.length; ++i) {
            if (_parts[i] == null) continue;
            allParts.append(_parts[i]);
            if (_parts[i].endsWith(File.separator)) continue;
            allParts.append(File.separator);
        }
        if (!_includeTrailingDelimiter && allParts.length() > 0) {
            return allParts.substring(0, allParts.lastIndexOf(File.separator));
        }
        return allParts.toString();
    }

    public static String getFileExtension(String _fileName) {
        if (_fileName == null) {
            return null;
        }
        int lastDot = _fileName.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        return _fileName.substring(lastDot + 1);
    }
}

