/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import com.github.hypfvieh.util.TypeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;

public final class StringUtil {
    private static final char[] SYMBOLS;

    private StringUtil() {
    }

    public static List<String> smartWordSplit(String _text, int _len) {
        if (_text == null) {
            return null;
        }
        if (_text.length() <= _len) {
            return TypeUtil.createList(_text);
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] result = _text.split("\\s");
        for (int x = 0; x < result.length; ++x) {
            if (result[x].length() > _len) {
                list.addAll(StringUtil.splitEqually(result[x], _len));
                continue;
            }
            if (result[x].length() < _len) {
                StringBuilder sb = new StringBuilder();
                x = StringUtil.strAppender(result, sb, x, _len);
                list.add(sb.toString());
                continue;
            }
            list.add(result[x]);
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int strAppender(String[] _text, StringBuilder _sbResult, int _beginIdx, int _len) {
        if (_text == null) return -1;
        if (_sbResult == null) {
            return -1;
        }
        if (_beginIdx > _text.length) {
            return _text.length;
        }
        int i = _beginIdx;
        i = _beginIdx;
        while (i < _text.length) {
            if (_sbResult.length() >= _len) {
                if (i <= _beginIdx) return i;
                return --i;
            }
            int condition = _text[i].length() + _sbResult.length();
            boolean firstOrLastToken = true;
            if (i <= _text.length - 1 && _sbResult.length() > 0) {
                ++condition;
                firstOrLastToken = false;
            }
            if (condition > _len) {
                return --i;
            }
            if (!firstOrLastToken) {
                _sbResult.append(" ");
            }
            _sbResult.append(_text[i]);
            ++i;
        }
        return i;
    }

    public static List<String> splitEqually(String _text, int _len) {
        if (_text == null) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>((_text.length() + _len - 1) / _len);
        for (int start = 0; start < _text.length(); start += _len) {
            ret.add(_text.substring(start, Math.min(_text.length(), start + _len)));
        }
        return ret;
    }

    public static String replaceByMap(String _searchStr, Map<String, String> _replacements) {
        if (_searchStr == null) {
            return null;
        }
        if (_replacements == null || _replacements.isEmpty()) {
            return _searchStr;
        }
        String str = _searchStr;
        for (Map.Entry<String, String> entry : _replacements.entrySet()) {
            str = str.replace(entry.getKey(), entry.getValue());
        }
        return str;
    }

    public static String lowerCaseFirstChar(String _str) {
        if (_str == null) {
            return null;
        }
        return _str.substring(0, 1).toLowerCase() + _str.substring(1);
    }

    public static String upperCaseFirstChar(String _str) {
        if (_str == null) {
            return null;
        }
        return _str.substring(0, 1).toUpperCase() + _str.substring(1);
    }

    public static String rot13(String _input) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < _input.length(); ++i) {
            char c = _input.charAt(i);
            if (c >= 'a' && c <= 'm') {
                c = (char)(c + 13);
            } else if (c >= 'A' && c <= 'M') {
                c = (char)(c + 13);
            } else if (c >= 'n' && c <= 'z') {
                c = (char)(c - 13);
            } else if (c >= 'N' && c <= 'Z') {
                c = (char)(c - 13);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean equalsIgnoreCaseAny(String _str, String ... _compare) {
        return StringUtil.equalsAny(true, _str, _compare);
    }

    public static boolean equalsAny(String _str, String ... _compare) {
        return StringUtil.equalsAny(false, _str, _compare);
    }

    public static boolean equalsAny(boolean _ignoreCase, String _str, String ... _compare) {
        if (_str == null && _compare == null || _compare.length == 0) {
            return true;
        }
        if (_str == null) {
            return false;
        }
        for (String cmp : _compare) {
            if (!(_ignoreCase ? cmp.equalsIgnoreCase(_str) : cmp.equals(_str))) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlank(String _str) {
        if (_str == null) {
            return true;
        }
        return _str.trim().isEmpty();
    }

    public static String defaultIfBlank(String _str, String _default) {
        return StringUtil.isBlank(_str) ? _default : _str;
    }

    public static String randomString(int _length) {
        if (_length <= 0) {
            return "";
        }
        Random random = new Random();
        char[] buf = new char[_length];
        for (int idx = 0; idx < buf.length; ++idx) {
            buf[idx] = SYMBOLS[random.nextInt(SYMBOLS.length)];
        }
        return new String(buf);
    }

    public static String join(String _delimiter, List<String> _strings) {
        if (_strings == null) {
            return null;
        }
        if (_delimiter == null) {
            _delimiter = "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < _strings.size(); ++i) {
            sb.append(_strings.get(i));
            if (i >= _strings.size() - 1) continue;
            sb.append(_delimiter);
        }
        return sb.toString();
    }

    public static String join(String _delimiter, String[] _strings) {
        return StringUtil.join(_delimiter, Arrays.asList(_strings));
    }

    static {
        char ch;
        StringBuilder tmp = new StringBuilder();
        for (ch = '0'; ch <= '9'; ch = (char)(ch + '\u0001')) {
            tmp.append(ch);
        }
        for (ch = 'a'; ch <= 'z'; ch = (char)(ch + '\u0001')) {
            tmp.append(ch);
        }
        for (ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            tmp.append(ch);
        }
        SYMBOLS = tmp.toString().toCharArray();
    }
}

