/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import com.github.hypfvieh.util.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemUtil.class);

    private SystemUtil() {
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException _ex) {
            return null;
        }
    }

    public static String getWorkingDirectory() {
        return System.getProperty("user.dir");
    }

    public static String getRunningClassPath() {
        return ClassLoader.getSystemClassLoader().getResource(".").getPath();
    }

    public static String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String concatFilePath(boolean _includeTrailingDelimiter, String ... _parts) {
        if (_parts == null) {
            return null;
        }
        StringBuilder allParts = new StringBuilder();
        for (int i = 0; i < _parts.length; ++i) {
            if (_parts[i] == null) continue;
            allParts.append(_parts[i]);
            if (_parts[i].endsWith(File.separator)) continue;
            allParts.append(File.separator);
        }
        if (!_includeTrailingDelimiter && allParts.length() > 0) {
            return allParts.substring(0, allParts.lastIndexOf(File.separator));
        }
        return allParts.toString();
    }

    public static String concatFilePath(String ... _parts) {
        return SystemUtil.concatFilePath(false, _parts);
    }

    public static String appendSuffixIfMissing(String _str, String _suffix) {
        if (_str == null) {
            return null;
        }
        if (!_str.endsWith(_suffix)) {
            _str = _str + _suffix;
        }
        return _str;
    }

    public static String appendTrailingDelimiter(String _filePath) {
        if (_filePath == null) {
            return null;
        }
        if (!_filePath.endsWith(File.separator)) {
            _filePath = _filePath + File.separator;
        }
        return _filePath;
    }

    public static File createTempDirectory(String _path, String _name, boolean _deleteOnExit) {
        File outputDir = new File(SystemUtil.concatFilePath(_path, _name));
        if (!outputDir.exists()) {
            try {
                Files.createDirectory(Paths.get(outputDir.toString(), new String[0]), new FileAttribute[0]);
            }
            catch (IOException _ex) {
                LOGGER.error("Error while creating temp directory: ", (Throwable)_ex);
            }
        } else {
            return null;
        }
        if (_deleteOnExit) {
            outputDir.deleteOnExit();
        }
        return outputDir;
    }

    public static File createTempDirectory(String _path, String _prefix, int _length, boolean _timestamp, boolean _deleteOnExit) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd_HHmmss-SSS");
        String randomStr = StringUtil.randomString(_length);
        StringBuilder fileName = new StringBuilder();
        if (_prefix != null) {
            fileName.append(_prefix);
        }
        fileName.append(randomStr);
        if (_timestamp) {
            fileName.append("_").append(formatter.format(new Date()));
        }
        File result = SystemUtil.createTempDirectory(_path, fileName.toString(), _deleteOnExit);
        while (result == null) {
            result = SystemUtil.createTempDirectory(_path, _prefix, _length, _timestamp, _deleteOnExit);
        }
        return result;
    }

    public static boolean isDebuggingEnabled() {
        boolean debuggingEnabled = false;
        if (ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0) {
            debuggingEnabled = true;
        } else if (ManagementFactory.getRuntimeMXBean().getInputArguments().contains("-Xdebug")) {
            debuggingEnabled = true;
        } else if (System.getProperty("debug", "").equals("true")) {
            debuggingEnabled = true;
        }
        return debuggingEnabled;
    }

    public static String getFileExtension(String _fileName) {
        if (_fileName == null) {
            return null;
        }
        int lastDot = _fileName.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        return _fileName.substring(lastDot + 1);
    }

    public static File getFileIfReadable(String _file) throws IOException {
        if (StringUtil.isBlank(_file)) {
            throw new IOException("Empty or null string is not a valid file");
        }
        File file = new File(_file);
        if (!file.exists()) {
            throw new FileNotFoundException("No such file: " + _file);
        }
        if (!file.isFile()) {
            throw new IOException("Not a file: " + _file);
        }
        if (!file.canRead()) {
            throw new AccessDeniedException("File not readable: " + _file);
        }
        return file;
    }

    public static String formatBytesHumanReadable(long _bytes, boolean _use1000BytesPerMb) {
        int unit;
        int n = unit = _use1000BytesPerMb ? 1000 : 1024;
        if (_bytes < (long)unit) {
            return _bytes + " B";
        }
        int exp = (int)(Math.log(_bytes) / Math.log(unit));
        String pre = (_use1000BytesPerMb ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (_use1000BytesPerMb ? "" : "i");
        return String.format("%.1f %sB", (double)_bytes / Math.pow(unit, exp), pre);
    }
}

