/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.matthew.io;

import java.io.OutputStream;
import java.io.PrintStream;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMPrinter {
    public static void printNode(Node n, OutputStream os) {
        PrintStream p = new PrintStream(os);
        DOMPrinter.printNode(n, p);
    }

    private DOMPrinter() {
    }

    public static void printNode(Node n, PrintStream p) {
        if (null != n.getNodeValue()) {
            p.print(n.getNodeValue());
        } else {
            int i;
            p.print("<" + n.getNodeName());
            if (n.hasAttributes()) {
                NamedNodeMap nnm = n.getAttributes();
                for (i = 0; i < nnm.getLength(); ++i) {
                    Node attr = nnm.item(i);
                    p.print(" " + attr.getNodeName() + "='" + attr.getNodeValue() + "'");
                }
            }
            if (n.hasChildNodes()) {
                p.print(">");
                NodeList nl = n.getChildNodes();
                for (i = 0; i < nl.getLength(); ++i) {
                    DOMPrinter.printNode(nl.item(i), p);
                }
                p.print("</" + n.getNodeName() + ">");
            } else {
                p.print("/>");
            }
        }
    }

    public static void printDOM(Document d, PrintStream p) {
        DocumentType dt = d.getDoctype();
        if (null != dt) {
            p.print("<!DOCTYPE " + dt.getName());
            String pub = dt.getPublicId();
            String sys = dt.getSystemId();
            if (null != pub) {
                p.print(" PUBLIC \"" + pub + "\" \"" + sys + "\"");
            } else if (null != sys) {
                p.print(" SYSTEM \"" + sys + "\"");
            }
            p.println(">");
        }
        Element e = d.getDocumentElement();
        DOMPrinter.printNode((Node)e, p);
    }

    public static void printDOM(Document d, OutputStream os) {
        PrintStream p = new PrintStream(os);
        DOMPrinter.printDOM(d, p);
    }
}

