/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.matthew.io;

import cx.ath.matthew.io.InOutCopier;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ExecInputStream
extends FilterInputStream {
    private Process proc;
    private InputStream stdout;
    private OutputStream stdin;
    private InOutCopier copy;

    public ExecInputStream(InputStream is, Process p) throws IOException {
        super(is);
        this.proc = p;
        this.stdin = p.getOutputStream();
        this.stdout = p.getInputStream();
        this.copy = new InOutCopier(this.in, this.stdin);
        this.copy.start();
    }

    public ExecInputStream(InputStream is, String cmd) throws IOException {
        this(is, Runtime.getRuntime().exec(cmd));
    }

    public ExecInputStream(InputStream is, String[] cmd) throws IOException {
        this(is, Runtime.getRuntime().exec(cmd));
    }

    public ExecInputStream(InputStream is, String cmd, String[] env) throws IOException {
        this(is, Runtime.getRuntime().exec(cmd, env));
    }

    public ExecInputStream(InputStream is, String[] cmd, String[] env) throws IOException {
        this(is, Runtime.getRuntime().exec(cmd, env));
    }

    @Override
    public void close() throws IOException {
        try {
            this.proc.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.copy.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.stdin.close();
        this.in.close();
        this.stdout.close();
    }

    public void flush() throws IOException {
        this.copy.flush();
    }

    @Override
    public int available() throws IOException {
        return this.stdout.available();
    }

    @Override
    public int read() throws IOException {
        return this.stdout.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.stdout.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.stdout.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.stdout.skip(n);
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void reset() {
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

