/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.matthew.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class InOutCopier
extends Thread {
    private static final int BUFSIZE = 1024;
    private BufferedInputStream is;
    private OutputStream os;
    private boolean enable;

    public InOutCopier(InputStream _is, OutputStream _os) throws IOException {
        this.is = new BufferedInputStream(_is);
        this.os = _os;
        this.enable = true;
    }

    public void close() {
        this.enable = false;
        this.interrupt();
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    @Override
    public synchronized void start() {
        super.start();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        byte[] buf = new byte[1024];
        InOutCopier inOutCopier = this;
        synchronized (inOutCopier) {
            this.notifyAll();
        }
        while (this.enable) {
            try {
                int n = this.is.read(buf);
                if (0 > n) break;
                if (0 >= n) continue;
                this.os.write(buf, 0, n > 1024 ? 1024 : n);
                this.os.flush();
            }
            catch (IOException exIo) {
                // empty catch block
                break;
            }
        }
        try {
            this.os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

