/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.util.Shell;

public class WindowsPathUtil {
    public static void convertPathsFromWindowsToHdfs(HiveConf conf) {
        String orgWarehouseDir = conf.getVar(HiveConf.ConfVars.METASTOREWAREHOUSE);
        conf.setVar(HiveConf.ConfVars.METASTOREWAREHOUSE, WindowsPathUtil.getHdfsUriString(orgWarehouseDir));
        String orgTestTempDir = System.getProperty("test.tmp.dir");
        System.setProperty("test.tmp.dir", WindowsPathUtil.getHdfsUriString(orgTestTempDir));
        String orgTestWarehouseDir = System.getProperty("test.warehouse.dir");
        System.setProperty("test.warehouse.dir", WindowsPathUtil.getHdfsUriString(orgTestWarehouseDir));
        String orgScratchDir = conf.getVar(HiveConf.ConfVars.SCRATCHDIR);
        conf.setVar(HiveConf.ConfVars.SCRATCHDIR, WindowsPathUtil.getHdfsUriString(orgScratchDir));
    }

    public static String getHdfsUriString(String uriStr) {
        assert (uriStr != null);
        if (Shell.WINDOWS) {
            return uriStr.replace('\\', '/').replaceFirst("/[c-zC-Z]:", "/").replaceFirst("^[c-zC-Z]:", "");
        }
        return uriStr;
    }
}

