/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFromUtcTimestamp;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.mapred.JobConf;

public class TestUtilities
extends TestCase {
    public static final Log LOG = LogFactory.getLog(TestUtilities.class);

    public void testGetFileExtension() {
        JobConf jc = new JobConf();
        TestUtilities.assertEquals((String)"No extension for uncompressed unknown format", (String)"", (String)Utilities.getFileExtension((JobConf)jc, (boolean)false, null));
        TestUtilities.assertEquals((String)"No extension for compressed unknown format", (String)"", (String)Utilities.getFileExtension((JobConf)jc, (boolean)true, null));
        TestUtilities.assertEquals((String)"No extension for uncompressed text format", (String)"", (String)Utilities.getFileExtension((JobConf)jc, (boolean)false, (HiveOutputFormat)new HiveIgnoreKeyTextOutputFormat()));
        TestUtilities.assertEquals((String)"Deflate for uncompressed text format", (String)".deflate", (String)Utilities.getFileExtension((JobConf)jc, (boolean)true, (HiveOutputFormat)new HiveIgnoreKeyTextOutputFormat()));
        TestUtilities.assertEquals((String)"No extension for uncompressed default format", (String)"", (String)Utilities.getFileExtension((JobConf)jc, (boolean)false));
        TestUtilities.assertEquals((String)"Deflate for uncompressed default format", (String)".deflate", (String)Utilities.getFileExtension((JobConf)jc, (boolean)true));
        String extension = ".myext";
        jc.set("hive.output.file.extension", extension);
        TestUtilities.assertEquals((String)"Custom extension for uncompressed unknown format", (String)extension, (String)Utilities.getFileExtension((JobConf)jc, (boolean)false, null));
        TestUtilities.assertEquals((String)"Custom extension for compressed unknown format", (String)extension, (String)Utilities.getFileExtension((JobConf)jc, (boolean)true, null));
        TestUtilities.assertEquals((String)"Custom extension for uncompressed text format", (String)extension, (String)Utilities.getFileExtension((JobConf)jc, (boolean)false, (HiveOutputFormat)new HiveIgnoreKeyTextOutputFormat()));
        TestUtilities.assertEquals((String)"Custom extension for uncompressed text format", (String)extension, (String)Utilities.getFileExtension((JobConf)jc, (boolean)true, (HiveOutputFormat)new HiveIgnoreKeyTextOutputFormat()));
    }

    public void testSerializeTimestamp() {
        Timestamp ts = new Timestamp(1374554702000L);
        ts.setNanos(123456);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((Object)ts);
        ArrayList<ExprNodeConstantDesc> children = new ArrayList<ExprNodeConstantDesc>(1);
        children.add(constant);
        ExprNodeGenericFuncDesc desc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.timestampTypeInfo, (GenericUDF)new GenericUDFFromUtcTimestamp(), children);
        TestUtilities.assertEquals((String)desc.getExprString(), (String)Utilities.deserializeExpression((String)Utilities.serializeExpression((ExprNodeGenericFuncDesc)desc)).getExprString());
    }

    public void testgetDbTableName() throws HiveException {
        SessionState.start((HiveConf)new HiveConf(((Object)((Object)this)).getClass()));
        String curDefaultdb = SessionState.get().getCurrentDatabase();
        String tablename = "tab1";
        String[] dbtab = Utilities.getDbTableName((String)tablename);
        TestUtilities.assertEquals((String)"db name", (String)curDefaultdb, (String)dbtab[0]);
        TestUtilities.assertEquals((String)"table name", (String)tablename, (String)dbtab[1]);
        tablename = "dab1.tab1";
        dbtab = Utilities.getDbTableName((String)tablename);
        TestUtilities.assertEquals((String)"db name", (String)"dab1", (String)dbtab[0]);
        TestUtilities.assertEquals((String)"table name", (String)"tab1", (String)dbtab[1]);
        tablename = "dab1.tab1.x1";
        try {
            dbtab = Utilities.getDbTableName((String)tablename);
            TestUtilities.fail((String)"exception was expected for invalid table name");
        }
        catch (HiveException ex) {
            TestUtilities.assertEquals((String)("Invalid table name " + tablename), (String)ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetJarFilesByPath() {
        File f = Files.createTempDir();
        String jarFileName1 = f.getAbsolutePath() + File.separator + "a.jar";
        String jarFileName2 = f.getAbsolutePath() + File.separator + "b.jar";
        File jarFile = new File(jarFileName1);
        try {
            FileUtils.touch((File)jarFile);
            HashSet jars = (HashSet)Utilities.getJarFilesByPath((String)f.getAbsolutePath());
            Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{jarFile.getAbsolutePath()}), (Object)jars);
            File jarFile2 = new File(jarFileName2);
            FileUtils.touch((File)jarFile2);
            String newPath = "file://" + jarFileName1 + ",file://" + jarFileName2;
            jars = (HashSet)Utilities.getJarFilesByPath((String)newPath);
            Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"file://" + jarFileName1, "file://" + jarFileName2}), (Object)jars);
        }
        catch (IOException e) {
            LOG.error((Object)"failed to copy file to reloading folder", (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
        finally {
            FileUtils.deleteQuietly((File)f);
        }
    }
}

