/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ColAndCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ColOrCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.DoubleColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterExprAndExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterExprOrExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IsNotNull;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IsNull;
import org.apache.hadoop.hive.ql.exec.vector.expressions.LongColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NotCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.SelectColumnIsFalse;
import org.apache.hadoop.hive.ql.exec.vector.expressions.SelectColumnIsNotNull;
import org.apache.hadoop.hive.ql.exec.vector.expressions.SelectColumnIsNull;
import org.apache.hadoop.hive.ql.exec.vector.expressions.SelectColumnIsTrue;
import org.apache.hadoop.hive.ql.exec.vector.expressions.TestVectorMathFunctions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorLogicalExpressions {
    private static final int BOOLEAN_COLUMN_TEST_SIZE = 9;

    @Test
    public void testLongColOrLongCol() {
        VectorizedRowBatch batch = this.getBatchThreeBooleanCols();
        ColOrCol expr = new ColOrCol(0, 1, 2);
        LongColumnVector outCol = (LongColumnVector)batch.cols[2];
        expr.evaluate(batch);
        Assert.assertEquals((long)0L, (long)outCol.vector[0]);
        Assert.assertEquals((long)1L, (long)outCol.vector[1]);
        Assert.assertEquals((long)1L, (long)outCol.vector[2]);
        Assert.assertEquals((long)1L, (long)outCol.vector[3]);
        Assert.assertFalse((boolean)outCol.isNull[3]);
        Assert.assertTrue((boolean)outCol.isNull[4]);
        Assert.assertEquals((long)1L, (long)outCol.vector[5]);
        Assert.assertTrue((boolean)outCol.isNull[6]);
        Assert.assertEquals((long)1L, (long)outCol.vector[7]);
        Assert.assertTrue((boolean)outCol.isNull[8]);
        Assert.assertEquals((long)batch.size, (long)9L);
        Assert.assertFalse((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        batch = this.getBatchThreeBooleanCols();
        batch.cols[0].noNulls = true;
        batch.cols[1].noNulls = true;
        batch.cols[2].noNulls = false;
        outCol = (LongColumnVector)batch.cols[2];
        expr.evaluate(batch);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertEquals((long)0L, (long)outCol.vector[0]);
        Assert.assertEquals((long)1L, (long)outCol.vector[1]);
        Assert.assertEquals((long)1L, (long)outCol.vector[2]);
        Assert.assertEquals((long)1L, (long)outCol.vector[3]);
        batch = this.getBatchThreeBooleanCols();
        batch.cols[0].noNulls = true;
        batch.cols[0].isRepeating = true;
        batch.cols[1].noNulls = true;
        batch.cols[1].isRepeating = false;
        batch.cols[2].noNulls = false;
        batch.cols[2].isRepeating = true;
        outCol = (LongColumnVector)batch.cols[2];
        expr.evaluate(batch);
        Assert.assertFalse((boolean)outCol.isRepeating);
        Assert.assertEquals((long)0L, (long)outCol.vector[0]);
        Assert.assertEquals((long)1L, (long)outCol.vector[1]);
        Assert.assertEquals((long)0L, (long)outCol.vector[2]);
        Assert.assertEquals((long)1L, (long)outCol.vector[3]);
    }

    @Test
    public void testLongColAndLongCol() {
        VectorizedRowBatch batch = this.getBatchThreeBooleanCols();
        ColAndCol expr = new ColAndCol(0, 1, 2);
        LongColumnVector outCol = (LongColumnVector)batch.cols[2];
        expr.evaluate(batch);
        Assert.assertEquals((long)0L, (long)outCol.vector[0]);
        Assert.assertEquals((long)0L, (long)outCol.vector[1]);
        Assert.assertEquals((long)0L, (long)outCol.vector[2]);
        Assert.assertEquals((long)1L, (long)outCol.vector[3]);
        Assert.assertEquals((long)0L, (long)outCol.vector[4]);
        Assert.assertFalse((boolean)outCol.isNull[4]);
        Assert.assertTrue((boolean)outCol.isNull[5]);
        Assert.assertEquals((long)0L, (long)outCol.vector[6]);
        Assert.assertFalse((boolean)outCol.isNull[6]);
        Assert.assertTrue((boolean)outCol.isNull[7]);
        Assert.assertTrue((boolean)outCol.isNull[8]);
        Assert.assertEquals((long)batch.size, (long)9L);
        Assert.assertFalse((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        batch = this.getBatchThreeBooleanCols();
        batch.cols[0].noNulls = true;
        batch.cols[1].noNulls = true;
        batch.cols[2].noNulls = false;
        outCol = (LongColumnVector)batch.cols[2];
        expr.evaluate(batch);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertEquals((long)0L, (long)outCol.vector[0]);
        Assert.assertEquals((long)0L, (long)outCol.vector[1]);
        Assert.assertEquals((long)0L, (long)outCol.vector[2]);
        Assert.assertEquals((long)1L, (long)outCol.vector[3]);
        batch = this.getBatchThreeBooleanCols();
        ((LongColumnVector)batch.cols[0]).vector[0] = 1L;
        batch.cols[0].noNulls = true;
        batch.cols[0].isRepeating = true;
        batch.cols[1].noNulls = true;
        batch.cols[1].isRepeating = false;
        batch.cols[2].noNulls = false;
        batch.cols[2].isRepeating = true;
        outCol = (LongColumnVector)batch.cols[2];
        expr.evaluate(batch);
        Assert.assertFalse((boolean)outCol.isRepeating);
        Assert.assertEquals((long)0L, (long)outCol.vector[0]);
        Assert.assertEquals((long)1L, (long)outCol.vector[1]);
        Assert.assertEquals((long)0L, (long)outCol.vector[2]);
        Assert.assertEquals((long)1L, (long)outCol.vector[3]);
    }

    private VectorizedRowBatch getBatchThreeBooleanCols() {
        VectorizedRowBatch batch = new VectorizedRowBatch(3, 1024);
        LongColumnVector v0 = new LongColumnVector(1024);
        LongColumnVector v1 = new LongColumnVector(1024);
        LongColumnVector v2 = new LongColumnVector(1024);
        batch.cols[0] = v0;
        batch.cols[1] = v1;
        batch.cols[2] = v2;
        int i = 0;
        v0.vector[i] = 0L;
        v0.isNull[i] = false;
        v1.vector[i] = 0L;
        v1.isNull[i] = false;
        i = 1;
        v0.vector[i] = 0L;
        v0.isNull[i] = false;
        v1.vector[i] = 1L;
        v1.isNull[i] = false;
        i = 2;
        v0.vector[i] = 1L;
        v0.isNull[i] = false;
        v1.vector[i] = 0L;
        v1.isNull[i] = false;
        i = 3;
        v0.vector[i] = 1L;
        v0.isNull[i] = false;
        v1.vector[i] = 1L;
        v1.isNull[i] = false;
        i = 4;
        v0.vector[i] = 0L;
        v0.isNull[i] = true;
        v1.vector[i] = 0L;
        v1.isNull[i] = false;
        i = 5;
        v0.vector[i] = 0L;
        v0.isNull[i] = true;
        v1.vector[i] = 1L;
        v1.isNull[i] = false;
        i = 6;
        v0.vector[i] = 0L;
        v0.isNull[i] = false;
        v1.vector[i] = 0L;
        v1.isNull[i] = true;
        i = 7;
        v0.vector[i] = 1L;
        v0.isNull[i] = false;
        v1.vector[i] = 1L;
        v1.isNull[i] = true;
        i = 8;
        v0.vector[i] = 1L;
        v0.isNull[i] = true;
        v1.vector[i] = 1L;
        v1.isNull[i] = true;
        v0.noNulls = false;
        v1.noNulls = false;
        v0.isRepeating = false;
        v1.isRepeating = false;
        v2.isRepeating = true;
        v2.noNulls = true;
        batch.size = 9;
        return batch;
    }

    @Test
    public void testBooleanNot() {
        VectorizedRowBatch batch = this.getBatchThreeBooleanCols();
        NotCol expr = new NotCol(0, 2);
        LongColumnVector outCol = (LongColumnVector)batch.cols[2];
        expr.evaluate(batch);
        Assert.assertFalse((boolean)outCol.isRepeating);
        Assert.assertEquals((long)1L, (long)outCol.vector[0]);
        Assert.assertFalse((boolean)outCol.isNull[0]);
        Assert.assertEquals((long)0L, (long)outCol.vector[2]);
        Assert.assertFalse((boolean)outCol.isNull[0]);
        Assert.assertTrue((boolean)outCol.isNull[4]);
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        Assert.assertFalse((boolean)outCol.isRepeating);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertEquals((long)1L, (long)outCol.vector[0]);
        Assert.assertEquals((long)0L, (long)outCol.vector[2]);
        batch = this.getBatchThreeBooleanCols();
        outCol = (LongColumnVector)batch.cols[2];
        batch.cols[0].isRepeating = true;
        batch.cols[0].isNull[0] = true;
        expr.evaluate(batch);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertTrue((boolean)outCol.isNull[0]);
        batch = this.getBatchThreeBooleanCols();
        outCol = (LongColumnVector)batch.cols[2];
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertEquals((long)1L, (long)outCol.vector[0]);
    }

    @Test
    public void testIsNullExpr() {
        VectorizedRowBatch batch = this.getBatchThreeBooleanCols();
        IsNull expr = new IsNull(0, 2);
        LongColumnVector outCol = (LongColumnVector)batch.cols[2];
        expr.evaluate(batch);
        Assert.assertEquals((long)0L, (long)outCol.vector[0]);
        Assert.assertEquals((long)1L, (long)outCol.vector[4]);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertEquals((long)0L, (long)outCol.vector[0]);
        batch = this.getBatchThreeBooleanCols();
        outCol = (LongColumnVector)batch.cols[2];
        batch.cols[0].isRepeating = true;
        batch.cols[0].isNull[0] = true;
        expr.evaluate(batch);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertEquals((long)1L, (long)outCol.vector[0]);
        Assert.assertTrue((boolean)outCol.noNulls);
        batch = this.getBatchThreeBooleanCols();
        outCol = (LongColumnVector)batch.cols[2];
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertEquals((long)0L, (long)outCol.vector[0]);
    }

    @Test
    public void testIsNotNullExpr() {
        VectorizedRowBatch batch = this.getBatchThreeBooleanCols();
        IsNotNull expr = new IsNotNull(0, 2);
        LongColumnVector outCol = (LongColumnVector)batch.cols[2];
        expr.evaluate(batch);
        Assert.assertEquals((long)1L, (long)outCol.vector[0]);
        Assert.assertEquals((long)0L, (long)outCol.vector[4]);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertEquals((long)1L, (long)outCol.vector[0]);
        batch = this.getBatchThreeBooleanCols();
        outCol = (LongColumnVector)batch.cols[2];
        batch.cols[0].isRepeating = true;
        batch.cols[0].isNull[0] = true;
        expr.evaluate(batch);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertEquals((long)0L, (long)outCol.vector[0]);
        Assert.assertTrue((boolean)outCol.noNulls);
        batch = this.getBatchThreeBooleanCols();
        outCol = (LongColumnVector)batch.cols[2];
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertEquals((long)1L, (long)outCol.vector[0]);
    }

    @Test
    public void testBooleanFiltersOnColumns() {
        VectorizedRowBatch batch = this.getBatchThreeBooleanCols();
        SelectColumnIsTrue expr = new SelectColumnIsTrue(0);
        expr.evaluate(batch);
        Assert.assertEquals((long)3L, (long)batch.size);
        Assert.assertEquals((long)2L, (long)batch.selected[0]);
        Assert.assertEquals((long)3L, (long)batch.selected[1]);
        Assert.assertEquals((long)7L, (long)batch.selected[2]);
        batch = this.getBatchThreeBooleanCols();
        SelectColumnIsFalse expr1 = new SelectColumnIsFalse(1);
        expr1.evaluate(batch);
        Assert.assertEquals((long)3L, (long)batch.size);
        Assert.assertEquals((long)0L, (long)batch.selected[0]);
        Assert.assertEquals((long)2L, (long)batch.selected[1]);
        Assert.assertEquals((long)4L, (long)batch.selected[2]);
    }

    @Test
    public void testSelectColumnIsNull() {
        VectorizedRowBatch batch = this.getBatchThreeBooleanCols();
        SelectColumnIsNull expr = new SelectColumnIsNull(0);
        expr.evaluate(batch);
        Assert.assertEquals((long)3L, (long)batch.size);
        Assert.assertEquals((long)4L, (long)batch.selected[0]);
        Assert.assertEquals((long)5L, (long)batch.selected[1]);
        Assert.assertEquals((long)8L, (long)batch.selected[2]);
        batch = this.getBatchThreeBooleanCols();
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)0L, (long)batch.size);
        batch = this.getBatchThreeBooleanCols();
        batch.cols[0].isRepeating = true;
        batch.cols[0].isNull[0] = true;
        int initialSize = batch.size;
        expr.evaluate(batch);
        Assert.assertEquals((long)initialSize, (long)batch.size);
        batch = this.getBatchThreeBooleanCols();
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)0L, (long)batch.size);
    }

    @Test
    public void testSelectColumnIsNotNull() {
        VectorizedRowBatch batch = this.getBatchThreeBooleanCols();
        SelectColumnIsNotNull expr = new SelectColumnIsNotNull(0);
        expr.evaluate(batch);
        Assert.assertEquals((long)6L, (long)batch.size);
        Assert.assertEquals((long)0L, (long)batch.selected[0]);
        Assert.assertEquals((long)1L, (long)batch.selected[1]);
        Assert.assertEquals((long)2L, (long)batch.selected[2]);
        Assert.assertEquals((long)3L, (long)batch.selected[3]);
        Assert.assertEquals((long)6L, (long)batch.selected[4]);
        Assert.assertEquals((long)7L, (long)batch.selected[5]);
        batch = this.getBatchThreeBooleanCols();
        batch.cols[0].noNulls = true;
        int initialSize = batch.size;
        expr.evaluate(batch);
        Assert.assertEquals((long)initialSize, (long)batch.size);
        batch = this.getBatchThreeBooleanCols();
        batch.cols[0].isRepeating = true;
        batch.cols[0].isNull[0] = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)0L, (long)batch.size);
        batch = this.getBatchThreeBooleanCols();
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        initialSize = batch.size;
        expr.evaluate(batch);
        Assert.assertEquals((long)initialSize, (long)batch.size);
    }

    @Test
    public void testFilterExprOrExpr() {
        VectorizedRowBatch batch1 = this.getBatchThreeBooleanCols();
        VectorizedRowBatch batch2 = this.getBatchThreeBooleanCols();
        SelectColumnIsTrue expr1 = new SelectColumnIsTrue(0);
        SelectColumnIsFalse expr2 = new SelectColumnIsFalse(1);
        FilterExprOrExpr orExpr = new FilterExprOrExpr();
        orExpr.setChildExpressions(new VectorExpression[]{expr1, expr2});
        orExpr.evaluate(batch1);
        orExpr.evaluate(batch2);
        Assert.assertEquals((long)batch1.size, (long)batch2.size);
        int j = 0;
        while (j < batch1.size) {
            Assert.assertEquals((long)batch1.selected[j], (long)batch2.selected[j]);
            int i = j++;
            Assert.assertEquals((long)((LongColumnVector)batch1.cols[0]).vector[i], (long)((LongColumnVector)batch2.cols[0]).vector[i]);
        }
        Assert.assertEquals((long)5L, (long)batch1.size);
        Assert.assertEquals((long)0L, (long)batch1.selected[0]);
        Assert.assertEquals((long)2L, (long)batch1.selected[1]);
        Assert.assertEquals((long)3L, (long)batch1.selected[2]);
        Assert.assertEquals((long)4L, (long)batch1.selected[3]);
        Assert.assertEquals((long)7L, (long)batch1.selected[4]);
        orExpr.evaluate(batch1);
        Assert.assertEquals((long)5L, (long)batch1.size);
        Assert.assertEquals((long)0L, (long)batch1.selected[0]);
        Assert.assertEquals((long)2L, (long)batch1.selected[1]);
        Assert.assertEquals((long)3L, (long)batch1.selected[2]);
        Assert.assertEquals((long)4L, (long)batch1.selected[3]);
        Assert.assertEquals((long)7L, (long)batch1.selected[4]);
    }

    @Test
    public void testFilterExprOrExprWithBatchReuse() {
        VectorizedRowBatch batch1 = this.getBatchThreeBooleanCols();
        SelectColumnIsTrue expr1 = new SelectColumnIsTrue(0);
        SelectColumnIsFalse expr2 = new SelectColumnIsFalse(1);
        FilterExprOrExpr orExpr = new FilterExprOrExpr();
        orExpr.setChildExpressions(new VectorExpression[]{expr1, expr2});
        orExpr.evaluate(batch1);
        for (int i = 0; i < 1024; ++i) {
            batch1.selected[i] = 0;
        }
        batch1.size = 9;
        batch1.selectedInUse = false;
        ColumnVector tmp = batch1.cols[0];
        batch1.cols[0] = batch1.cols[1];
        batch1.cols[1] = tmp;
        orExpr.evaluate(batch1);
        Assert.assertEquals((long)5L, (long)batch1.size);
        Assert.assertEquals((long)0L, (long)batch1.selected[0]);
        Assert.assertEquals((long)1L, (long)batch1.selected[1]);
        Assert.assertEquals((long)3L, (long)batch1.selected[2]);
        Assert.assertEquals((long)5L, (long)batch1.selected[3]);
        Assert.assertEquals((long)6L, (long)batch1.selected[4]);
    }

    @Test
    public void testFilterExprOrExprWithSelectInUse() {
        VectorizedRowBatch batch1 = this.getBatchThreeBooleanCols();
        SelectColumnIsTrue expr1 = new SelectColumnIsTrue(0);
        SelectColumnIsFalse expr2 = new SelectColumnIsFalse(1);
        FilterExprOrExpr orExpr = new FilterExprOrExpr();
        orExpr.setChildExpressions(new VectorExpression[]{expr1, expr2});
        orExpr.evaluate(batch1);
        ColumnVector tmp = batch1.cols[0];
        batch1.cols[0] = batch1.cols[1];
        batch1.cols[1] = tmp;
        batch1.cols[1].isNull[7] = false;
        ((LongColumnVector)batch1.cols[1]).vector[7] = 0L;
        orExpr.evaluate(batch1);
        Assert.assertEquals((long)3L, (long)batch1.size);
        Assert.assertEquals((long)0L, (long)batch1.selected[0]);
        Assert.assertEquals((long)3L, (long)batch1.selected[1]);
        Assert.assertEquals((long)7L, (long)batch1.selected[2]);
    }

    @Test
    public void testFilterExprAndExpr() {
        VectorizedRowBatch batch1 = this.getBatchThreeBooleanCols();
        SelectColumnIsTrue expr1 = new SelectColumnIsTrue(0);
        SelectColumnIsFalse expr2 = new SelectColumnIsFalse(1);
        FilterExprAndExpr andExpr = new FilterExprAndExpr();
        andExpr.setChildExpressions(new VectorExpression[]{expr1, expr2});
        andExpr.evaluate(batch1);
        Assert.assertEquals((long)1L, (long)batch1.size);
        Assert.assertEquals((long)2L, (long)batch1.selected[0]);
    }

    @Test
    public void testLongInExpr() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchLongInLongOut();
        LongColumnVector outV = (LongColumnVector)b.cols[1];
        long[] inVals = new long[]{0L, -2L};
        LongColumnInList expr = new LongColumnInList(0, 1);
        expr.setInListValues(inVals);
        expr.evaluate(b);
        Assert.assertEquals((long)1L, (long)outV.vector[0]);
        Assert.assertEquals((long)0L, (long)outV.vector[1]);
        b.cols[0].noNulls = false;
        b.cols[0].isNull[0] = true;
        expr.evaluate(b);
        Assert.assertEquals((Object)true, (Object)(!outV.noNulls && outV.isNull[0] ? 1 : 0));
        Assert.assertEquals((long)0L, (long)outV.vector[1]);
        b = TestVectorMathFunctions.getVectorizedRowBatchLongInLongOut();
        outV = (LongColumnVector)b.cols[1];
        b.cols[0].isRepeating = true;
        expr.evaluate(b);
        Assert.assertEquals((Object)true, (Object)outV.isRepeating);
        Assert.assertEquals((long)1L, (long)outV.vector[0]);
    }

    @Test
    public void testDoubleInExpr() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInLongOut();
        LongColumnVector outV = (LongColumnVector)b.cols[1];
        double[] inVals = new double[]{-1.5, 30.0};
        b.size = 2;
        DoubleColumnInList expr = new DoubleColumnInList(0, 1);
        expr.setInListValues(inVals);
        expr.evaluate(b);
        Assert.assertEquals((long)1L, (long)outV.vector[0]);
        Assert.assertEquals((long)0L, (long)outV.vector[1]);
        b.cols[0].noNulls = false;
        b.cols[0].isNull[0] = true;
        expr.evaluate(b);
        Assert.assertEquals((Object)true, (Object)(!outV.noNulls && outV.isNull[0] ? 1 : 0));
        Assert.assertEquals((long)0L, (long)outV.vector[1]);
        b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInLongOut();
        outV = (LongColumnVector)b.cols[1];
        b.cols[0].isRepeating = true;
        expr.evaluate(b);
        Assert.assertEquals((Object)true, (Object)outV.isRepeating);
        Assert.assertEquals((long)1L, (long)outV.vector[0]);
    }
}

