/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.util.Random;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.CommonFastHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.RandomByteArrayStream;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastMultiKeyHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMapResult;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorMapJoinFastMultiKeyHashMap
extends CommonFastHashTable {
    @Test
    public void testPutGetOne() throws Exception {
        random = new Random(47496L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 8, 0.75f, 128);
        RandomByteArrayStream randomByteArrayKeyStream = new RandomByteArrayStream(random);
        RandomByteArrayStream randomByteArrayValueStream = new RandomByteArrayStream(random);
        byte[] key = randomByteArrayKeyStream.next();
        byte[] value = randomByteArrayValueStream.next();
        map.putRow(key, value);
        this.verifyHashMapResult(map, key, randomByteArrayValueStream.get(0));
        key = randomByteArrayKeyStream.next();
        value = randomByteArrayValueStream.next();
        map.putRow(key, value);
        this.verifyHashMapResult(map, key, randomByteArrayValueStream.get(1));
    }

    @Test
    public void testPutGetMultiple() throws Exception {
        random = new Random(2990L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 8, 0.75f, 128);
        RandomByteArrayStream randomByteArrayKeyStream = new RandomByteArrayStream(random);
        RandomByteArrayStream randomByteArrayValueStream = new RandomByteArrayStream(random);
        byte[] key = randomByteArrayKeyStream.next();
        byte[] value = randomByteArrayValueStream.next();
        map.putRow(key, value);
        this.verifyHashMapResult(map, key, value);
        for (int i = 0; i < 3; ++i) {
            value = randomByteArrayValueStream.next();
            map.putRow(key, value);
            this.verifyHashMapResult(map, key, randomByteArrayValueStream);
        }
    }

    @Test
    public void testGetNonExistent() throws Exception {
        random = new Random(16916L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 8, 0.75f, 128);
        RandomByteArrayStream randomByteArrayKeyStream = new RandomByteArrayStream(random);
        RandomByteArrayStream randomByteArrayValueStream = new RandomByteArrayStream(random);
        byte[] key = randomByteArrayKeyStream.next();
        byte[] value = randomByteArrayValueStream.next();
        map.putRow(key, value);
        key[0] = (byte)(key[0] + 1);
        map.putRow(key, value);
        key[0] = (byte)(key[0] + 1);
        VectorMapJoinHashMapResult hashMapResult = map.createHashMapResult();
        JoinUtil.JoinResult joinResult = map.lookup(key, 0, key.length, hashMapResult);
        Assert.assertTrue((joinResult == JoinUtil.JoinResult.NOMATCH ? 1 : 0) != 0);
        Assert.assertTrue((!hashMapResult.hasRows() ? 1 : 0) != 0);
    }

    @Test
    public void testPutWithFullMap() throws Exception {
        VectorMapJoinHashMapResult hashMapResult;
        int i;
        random = new Random(26078L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 8, 1.0f, 128);
        RandomByteArrayStream randomByteArrayKeyStream = new RandomByteArrayStream(random);
        RandomByteArrayStream randomByteArrayValueStream = new RandomByteArrayStream(random);
        for (i = 0; i < 8; ++i) {
            byte[] key = randomByteArrayKeyStream.next();
            byte[] value = randomByteArrayValueStream.next();
            map.putRow(key, value);
        }
        for (i = 0; i < randomByteArrayKeyStream.size(); ++i) {
            this.verifyHashMapResult(map, randomByteArrayKeyStream.get(i), randomByteArrayValueStream.get(i));
        }
        byte[] anotherKey = randomByteArrayKeyStream.next();
        JoinUtil.JoinResult joinResult = map.lookup(anotherKey, 0, anotherKey.length, hashMapResult = map.createHashMapResult());
        Assert.assertTrue((joinResult == JoinUtil.JoinResult.NOMATCH ? 1 : 0) != 0);
    }

    @Test
    public void testExpand() throws Exception {
        random = new Random(22470L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 1, 1.0E-7f, 128);
        RandomByteArrayStream randomByteArrayKeyStream = new RandomByteArrayStream(random);
        RandomByteArrayStream randomByteArrayValueStream = new RandomByteArrayStream(random);
        for (int i = 0; i < 18; ++i) {
            byte[] key = randomByteArrayKeyStream.next();
            byte[] value = randomByteArrayValueStream.next();
            map.putRow(key, value);
            for (int j = 0; j <= i; ++j) {
                this.verifyHashMapResult(map, randomByteArrayKeyStream.get(j), randomByteArrayValueStream.get(j));
            }
        }
    }

    @Test
    public void testLarge() throws Exception {
        int i;
        random = new Random(5231L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 0x800000, 0.75f, 0x100000);
        RandomByteArrayStream randomByteArrayKeyStream = new RandomByteArrayStream(random, 10);
        int largeSize = 1000;
        RandomByteArrayStream[] randomByteArrayValueStreams = new RandomByteArrayStream[1000];
        for (i = 0; i < 1000; ++i) {
            VectorMapJoinHashMapResult hashMapResult;
            randomByteArrayValueStreams[i] = new RandomByteArrayStream(random);
            int count = TestVectorMapJoinFastMultiKeyHashMap.generateLargeCount();
            byte[] key = randomByteArrayKeyStream.next();
            JoinUtil.JoinResult joinResult = map.lookup(key, 0, key.length, hashMapResult = map.createHashMapResult());
            if (joinResult == JoinUtil.JoinResult.MATCH) {
                Assert.assertTrue((boolean)false);
            }
            for (int v = 0; v < count; ++v) {
                byte[] value = randomByteArrayValueStreams[i].next();
                map.putRow(key, value);
            }
        }
        for (i = 0; i < 1000; ++i) {
            this.verifyHashMapResult(map, randomByteArrayKeyStream.get(i), randomByteArrayValueStreams[i]);
        }
    }

    @Test
    public void testLargeAndExpand() throws Exception {
        int i;
        random = new Random(46809L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 512, 0.75f, 8192);
        RandomByteArrayStream randomByteArrayKeyStream = new RandomByteArrayStream(random, 10);
        int largeSize = 1000;
        RandomByteArrayStream[] randomByteArrayValueStreams = new RandomByteArrayStream[1000];
        for (i = 0; i < 1000; ++i) {
            VectorMapJoinHashMapResult hashMapResult;
            randomByteArrayValueStreams[i] = new RandomByteArrayStream(random);
            int count = TestVectorMapJoinFastMultiKeyHashMap.generateLargeCount();
            byte[] key = randomByteArrayKeyStream.next();
            JoinUtil.JoinResult joinResult = map.lookup(key, 0, key.length, hashMapResult = map.createHashMapResult());
            if (joinResult == JoinUtil.JoinResult.MATCH) {
                Assert.assertTrue((boolean)false);
            }
            for (int v = 0; v < count; ++v) {
                byte[] value = randomByteArrayValueStreams[i].next();
                map.putRow(key, value);
            }
        }
        for (i = 0; i < 1000; ++i) {
            this.verifyHashMapResult(map, randomByteArrayKeyStream.get(i), randomByteArrayValueStreams[i]);
        }
    }

    private void verifyHashMapResult(VectorMapJoinFastMultiKeyHashMap map, byte[] key, RandomByteArrayStream randomByteArrayValueStream) {
        VectorMapJoinHashMapResult hashMapResult = map.createHashMapResult();
        JoinUtil.JoinResult joinResult = map.lookup(key, 0, key.length, hashMapResult);
        if (joinResult != JoinUtil.JoinResult.MATCH) {
            Assert.assertTrue((boolean)false);
        }
        CommonFastHashTable.verifyHashMapResult(hashMapResult, randomByteArrayValueStream);
    }

    private void verifyHashMapResult(VectorMapJoinFastMultiKeyHashMap map, byte[] key, byte[] valueBytes) {
        VectorMapJoinHashMapResult hashMapResult = map.createHashMapResult();
        JoinUtil.JoinResult joinResult = map.lookup(key, 0, key.length, hashMapResult);
        if (joinResult != JoinUtil.JoinResult.MATCH) {
            Assert.assertTrue((boolean)false);
        }
        CommonFastHashTable.verifyHashMapResult(hashMapResult, valueBytes);
    }
}

