/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.ColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.IntegerColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.StringColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.StripeInformation;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.IntWritable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestOrcNullOptimization {
    Path workDir = new Path(System.getProperty("test.tmp.dir", "target" + File.separator + "test" + File.separator + "tmp"));
    Configuration conf;
    FileSystem fs;
    Path testFilePath;
    @Rule
    public TestName testCaseName = new TestName();

    @Before
    public void openFileSystem() throws Exception {
        this.conf = new Configuration();
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.testFilePath = new Path(this.workDir, "TestOrcNullOptimization." + this.testCaseName.getMethodName() + ".orc");
        this.fs.delete(this.testFilePath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiStripeWithNull() throws Exception {
        Class<TestOrcNullOptimization> clazz = TestOrcNullOptimization.class;
        synchronized (TestOrcNullOptimization.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(MyStruct.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(10000));
            Random rand = new Random(100L);
            writer.addRow((Object)new MyStruct(null, null, true, Lists.newArrayList((Object[])new InnerStruct[]{new InnerStruct(100)})));
            for (int i = 2; i < 20000; ++i) {
                writer.addRow((Object)new MyStruct(rand.nextInt(1), "a", true, Lists.newArrayList((Object[])new InnerStruct[]{new InnerStruct(100)})));
            }
            writer.addRow((Object)new MyStruct(null, null, true, Lists.newArrayList((Object[])new InnerStruct[]{new InnerStruct(100)})));
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            ColumnStatistics[] stats = reader.getStatistics();
            junit.framework.Assert.assertEquals((long)20000L, (long)reader.getNumberOfRows());
            junit.framework.Assert.assertEquals((long)20000L, (long)stats[0].getNumberOfValues());
            junit.framework.Assert.assertEquals((long)0L, (long)((IntegerColumnStatistics)stats[1]).getMaximum());
            junit.framework.Assert.assertEquals((long)0L, (long)((IntegerColumnStatistics)stats[1]).getMinimum());
            junit.framework.Assert.assertEquals((boolean)true, (boolean)((IntegerColumnStatistics)stats[1]).isSumDefined());
            junit.framework.Assert.assertEquals((long)0L, (long)((IntegerColumnStatistics)stats[1]).getSum());
            junit.framework.Assert.assertEquals((String)"count: 19998 hasNull: true min: 0 max: 0 sum: 0", (String)stats[1].toString());
            junit.framework.Assert.assertEquals((String)"a", (String)((StringColumnStatistics)stats[2]).getMaximum());
            junit.framework.Assert.assertEquals((String)"a", (String)((StringColumnStatistics)stats[2]).getMinimum());
            junit.framework.Assert.assertEquals((long)19998L, (long)stats[2].getNumberOfValues());
            junit.framework.Assert.assertEquals((String)"count: 19998 hasNull: true min: a max: a sum: 19998", (String)stats[2].toString());
            StructObjectInspector readerInspector = (StructObjectInspector)reader.getObjectInspector();
            junit.framework.Assert.assertEquals((Object)ObjectInspector.Category.STRUCT, (Object)readerInspector.getCategory());
            junit.framework.Assert.assertEquals((String)"struct<a:int,b:string,c:boolean,list:array<struct<z:int>>>", (String)readerInspector.getTypeName());
            RecordReader rows = reader.rows();
            ArrayList expected = Lists.newArrayList();
            for (Object sinfo : reader.getStripes()) {
                expected.add(false);
            }
            expected.set(0, true);
            expected.set(expected.size() - 1, true);
            ArrayList got = Lists.newArrayList();
            for (StripeInformation sinfo : reader.getStripes()) {
                OrcProto.StripeFooter sf = ((RecordReaderImpl)rows).readStripeFooter(sinfo);
                got.add(sf.toString().indexOf(OrcProto.Stream.Kind.PRESENT.toString()) != -1);
            }
            junit.framework.Assert.assertEquals((Object)expected, (Object)got);
            OrcStruct row = (OrcStruct)rows.next(null);
            junit.framework.Assert.assertNotNull((Object)row);
            Assert.assertNull((Object)row.getFieldValue(0));
            Assert.assertNull((Object)row.getFieldValue(1));
            junit.framework.Assert.assertEquals((Object)new BooleanWritable(true), (Object)row.getFieldValue(2));
            junit.framework.Assert.assertEquals((Object)new IntWritable(100), (Object)((OrcStruct)((ArrayList)row.getFieldValue(3)).get(0)).getFieldValue(0));
            rows.seekToRow(19998L);
            row = (OrcStruct)rows.next(null);
            junit.framework.Assert.assertNotNull((Object)row);
            junit.framework.Assert.assertNotNull((Object)row.getFieldValue(1));
            junit.framework.Assert.assertEquals((Object)new IntWritable(0), (Object)row.getFieldValue(0));
            junit.framework.Assert.assertEquals((Object)new BooleanWritable(true), (Object)row.getFieldValue(2));
            junit.framework.Assert.assertEquals((Object)new IntWritable(100), (Object)((OrcStruct)((ArrayList)row.getFieldValue(3)).get(0)).getFieldValue(0));
            row = (OrcStruct)rows.next((Object)row);
            junit.framework.Assert.assertNotNull((Object)row);
            Assert.assertNull((Object)row.getFieldValue(0));
            Assert.assertNull((Object)row.getFieldValue(1));
            junit.framework.Assert.assertEquals((Object)new BooleanWritable(true), (Object)row.getFieldValue(2));
            junit.framework.Assert.assertEquals((Object)new IntWritable(100), (Object)((OrcStruct)((ArrayList)row.getFieldValue(3)).get(0)).getFieldValue(0));
            rows.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiStripeWithoutNull() throws Exception {
        Class<TestOrcNullOptimization> clazz = TestOrcNullOptimization.class;
        synchronized (TestOrcNullOptimization.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(MyStruct.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).compress(CompressionKind.NONE).bufferSize(10000));
            Random rand = new Random(100L);
            for (int i = 1; i < 20000; ++i) {
                writer.addRow((Object)new MyStruct(rand.nextInt(1), "a", true, Lists.newArrayList((Object[])new InnerStruct[]{new InnerStruct(100)})));
            }
            writer.addRow((Object)new MyStruct(0, "b", true, Lists.newArrayList((Object[])new InnerStruct[]{new InnerStruct(100)})));
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            ColumnStatistics[] stats = reader.getStatistics();
            junit.framework.Assert.assertEquals((long)20000L, (long)reader.getNumberOfRows());
            junit.framework.Assert.assertEquals((long)20000L, (long)stats[0].getNumberOfValues());
            junit.framework.Assert.assertEquals((long)0L, (long)((IntegerColumnStatistics)stats[1]).getMaximum());
            junit.framework.Assert.assertEquals((long)0L, (long)((IntegerColumnStatistics)stats[1]).getMinimum());
            junit.framework.Assert.assertEquals((boolean)true, (boolean)((IntegerColumnStatistics)stats[1]).isSumDefined());
            junit.framework.Assert.assertEquals((long)0L, (long)((IntegerColumnStatistics)stats[1]).getSum());
            junit.framework.Assert.assertEquals((String)"count: 20000 hasNull: false min: 0 max: 0 sum: 0", (String)stats[1].toString());
            junit.framework.Assert.assertEquals((String)"b", (String)((StringColumnStatistics)stats[2]).getMaximum());
            junit.framework.Assert.assertEquals((String)"a", (String)((StringColumnStatistics)stats[2]).getMinimum());
            junit.framework.Assert.assertEquals((long)20000L, (long)stats[2].getNumberOfValues());
            junit.framework.Assert.assertEquals((String)"count: 20000 hasNull: false min: a max: b sum: 20000", (String)stats[2].toString());
            StructObjectInspector readerInspector = (StructObjectInspector)reader.getObjectInspector();
            junit.framework.Assert.assertEquals((Object)ObjectInspector.Category.STRUCT, (Object)readerInspector.getCategory());
            junit.framework.Assert.assertEquals((String)"struct<a:int,b:string,c:boolean,list:array<struct<z:int>>>", (String)readerInspector.getTypeName());
            RecordReader rows = reader.rows();
            ArrayList expected = Lists.newArrayList();
            for (Object sinfo : reader.getStripes()) {
                expected.add(false);
            }
            ArrayList got = Lists.newArrayList();
            for (StripeInformation sinfo : reader.getStripes()) {
                OrcProto.StripeFooter sf = ((RecordReaderImpl)rows).readStripeFooter(sinfo);
                got.add(sf.toString().indexOf(OrcProto.Stream.Kind.PRESENT.toString()) != -1);
            }
            junit.framework.Assert.assertEquals((Object)expected, (Object)got);
            rows.seekToRow(19998L);
            OrcStruct row = (OrcStruct)rows.next(null);
            junit.framework.Assert.assertNotNull((Object)row);
            junit.framework.Assert.assertNotNull((Object)row.getFieldValue(1));
            junit.framework.Assert.assertEquals((Object)new IntWritable(0), (Object)row.getFieldValue(0));
            junit.framework.Assert.assertEquals((String)"a", (String)row.getFieldValue(1).toString());
            junit.framework.Assert.assertEquals((Object)new BooleanWritable(true), (Object)row.getFieldValue(2));
            junit.framework.Assert.assertEquals((Object)new IntWritable(100), (Object)((OrcStruct)((ArrayList)row.getFieldValue(3)).get(0)).getFieldValue(0));
            row = (OrcStruct)rows.next((Object)row);
            junit.framework.Assert.assertNotNull((Object)row);
            junit.framework.Assert.assertNotNull((Object)row.getFieldValue(0));
            junit.framework.Assert.assertNotNull((Object)row.getFieldValue(1));
            junit.framework.Assert.assertEquals((String)"b", (String)row.getFieldValue(1).toString());
            junit.framework.Assert.assertEquals((Object)new BooleanWritable(true), (Object)row.getFieldValue(2));
            junit.framework.Assert.assertEquals((Object)new IntWritable(100), (Object)((OrcStruct)((ArrayList)row.getFieldValue(3)).get(0)).getFieldValue(0));
            rows.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testColumnsWithNullAndCompression() throws Exception {
        Class<TestOrcNullOptimization> clazz = TestOrcNullOptimization.class;
        synchronized (TestOrcNullOptimization.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(MyStruct.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).bufferSize(10000));
            writer.addRow((Object)new MyStruct(3, "a", true, Lists.newArrayList((Object[])new InnerStruct[]{new InnerStruct(100)})));
            writer.addRow((Object)new MyStruct(null, "b", true, Lists.newArrayList((Object[])new InnerStruct[]{new InnerStruct(100)})));
            writer.addRow((Object)new MyStruct(3, null, false, Lists.newArrayList((Object[])new InnerStruct[]{new InnerStruct(100)})));
            writer.addRow((Object)new MyStruct(3, "d", true, Lists.newArrayList((Object[])new InnerStruct[]{new InnerStruct(100)})));
            writer.addRow((Object)new MyStruct(2, "e", true, Lists.newArrayList((Object[])new InnerStruct[]{new InnerStruct(100)})));
            writer.addRow((Object)new MyStruct(2, "f", true, Lists.newArrayList((Object[])new InnerStruct[]{new InnerStruct(100)})));
            writer.addRow((Object)new MyStruct(2, "g", true, Lists.newArrayList((Object[])new InnerStruct[]{new InnerStruct(100)})));
            writer.addRow((Object)new MyStruct(2, "h", true, Lists.newArrayList((Object[])new InnerStruct[]{new InnerStruct(100)})));
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            ColumnStatistics[] stats = reader.getStatistics();
            junit.framework.Assert.assertEquals((long)8L, (long)reader.getNumberOfRows());
            junit.framework.Assert.assertEquals((long)8L, (long)stats[0].getNumberOfValues());
            junit.framework.Assert.assertEquals((long)3L, (long)((IntegerColumnStatistics)stats[1]).getMaximum());
            junit.framework.Assert.assertEquals((long)2L, (long)((IntegerColumnStatistics)stats[1]).getMinimum());
            junit.framework.Assert.assertEquals((boolean)true, (boolean)((IntegerColumnStatistics)stats[1]).isSumDefined());
            junit.framework.Assert.assertEquals((long)17L, (long)((IntegerColumnStatistics)stats[1]).getSum());
            junit.framework.Assert.assertEquals((String)"count: 7 hasNull: true min: 2 max: 3 sum: 17", (String)stats[1].toString());
            junit.framework.Assert.assertEquals((String)"h", (String)((StringColumnStatistics)stats[2]).getMaximum());
            junit.framework.Assert.assertEquals((String)"a", (String)((StringColumnStatistics)stats[2]).getMinimum());
            junit.framework.Assert.assertEquals((long)7L, (long)stats[2].getNumberOfValues());
            junit.framework.Assert.assertEquals((String)"count: 7 hasNull: true min: a max: h sum: 7", (String)stats[2].toString());
            StructObjectInspector readerInspector = (StructObjectInspector)reader.getObjectInspector();
            junit.framework.Assert.assertEquals((Object)ObjectInspector.Category.STRUCT, (Object)readerInspector.getCategory());
            junit.framework.Assert.assertEquals((String)"struct<a:int,b:string,c:boolean,list:array<struct<z:int>>>", (String)readerInspector.getTypeName());
            RecordReader rows = reader.rows();
            ArrayList expected = Lists.newArrayList();
            for (Object sinfo : reader.getStripes()) {
                expected.add(false);
            }
            expected.set(expected.size() - 1, true);
            ArrayList got = Lists.newArrayList();
            for (StripeInformation sinfo : reader.getStripes()) {
                OrcProto.StripeFooter sf = ((RecordReaderImpl)rows).readStripeFooter(sinfo);
                got.add(sf.toString().indexOf(OrcProto.Stream.Kind.PRESENT.toString()) != -1);
            }
            junit.framework.Assert.assertEquals((Object)expected, (Object)got);
            OrcStruct row = (OrcStruct)rows.next(null);
            junit.framework.Assert.assertNotNull((Object)row);
            junit.framework.Assert.assertEquals((Object)new IntWritable(3), (Object)row.getFieldValue(0));
            junit.framework.Assert.assertEquals((String)"a", (String)row.getFieldValue(1).toString());
            junit.framework.Assert.assertEquals((Object)new BooleanWritable(true), (Object)row.getFieldValue(2));
            junit.framework.Assert.assertEquals((Object)new IntWritable(100), (Object)((OrcStruct)((ArrayList)row.getFieldValue(3)).get(0)).getFieldValue(0));
            row = (OrcStruct)rows.next((Object)row);
            junit.framework.Assert.assertNotNull((Object)row);
            Assert.assertNull((Object)row.getFieldValue(0));
            junit.framework.Assert.assertEquals((String)"b", (String)row.getFieldValue(1).toString());
            junit.framework.Assert.assertEquals((Object)new BooleanWritable(true), (Object)row.getFieldValue(2));
            junit.framework.Assert.assertEquals((Object)new IntWritable(100), (Object)((OrcStruct)((ArrayList)row.getFieldValue(3)).get(0)).getFieldValue(0));
            row = (OrcStruct)rows.next((Object)row);
            junit.framework.Assert.assertNotNull((Object)row);
            Assert.assertNull((Object)row.getFieldValue(1));
            junit.framework.Assert.assertEquals((Object)new IntWritable(3), (Object)row.getFieldValue(0));
            junit.framework.Assert.assertEquals((Object)new BooleanWritable(false), (Object)row.getFieldValue(2));
            junit.framework.Assert.assertEquals((Object)new IntWritable(100), (Object)((OrcStruct)((ArrayList)row.getFieldValue(3)).get(0)).getFieldValue(0));
            rows.close();
            return;
        }
    }

    public static class InnerStruct {
        Integer z;

        public InnerStruct(int z) {
            this.z = z;
        }
    }

    public static class MyStruct {
        Integer a;
        String b;
        Boolean c;
        List<InnerStruct> list = new ArrayList<InnerStruct>();

        public MyStruct(Integer a, String b, Boolean c, List<InnerStruct> l) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.list = l;
        }
    }
}

