/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.collect.Lists;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import java.util.TimeZone;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.TestOrcFile;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestOrcTimezone2 {
    Path workDir = new Path(System.getProperty("test.tmp.dir", "target" + File.separator + "test" + File.separator + "tmp"));
    Configuration conf;
    FileSystem fs;
    Path testFilePath;
    String writerTimeZone;
    String readerTimeZone;
    static TimeZone defaultTimeZone = TimeZone.getDefault();
    @Rule
    public TestName testCaseName = new TestName();

    public TestOrcTimezone2(String writerTZ, String readerTZ) {
        this.writerTimeZone = writerTZ;
        this.readerTimeZone = readerTZ;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        String[] allTimeZones = TimeZone.getAvailableIDs();
        Random rand = new Random(123L);
        int len = allTimeZones.length;
        int n = 500;
        Object[][] data = new Object[n][];
        for (int i = 0; i < n; ++i) {
            int wIdx = rand.nextInt(len);
            int rIdx = rand.nextInt(len);
            data[i] = new Object[2];
            data[i][0] = allTimeZones[wIdx];
            data[i][1] = allTimeZones[rIdx];
        }
        return Arrays.asList(data);
    }

    @Before
    public void openFileSystem() throws Exception {
        this.conf = new Configuration();
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.testFilePath = new Path(this.workDir, "TestOrcFile." + this.testCaseName.getMethodName() + ".orc");
        this.fs.delete(this.testFilePath, false);
    }

    @After
    public void restoreTimeZone() {
        TimeZone.setDefault(defaultTimeZone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimestampWriter() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Timestamp.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            TimeZone.setDefault(TimeZone.getTimeZone(this.writerTimeZone));
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).bufferSize(10000));
            Assert.assertEquals((String)this.writerTimeZone, (String)TimeZone.getDefault().getID());
            ArrayList ts = Lists.newArrayList();
            ts.add("2003-01-01 01:00:00.000000222");
            ts.add("1999-01-01 02:00:00.999999999");
            ts.add("1995-01-02 03:00:00.688888888");
            ts.add("2002-01-01 04:00:00.1");
            ts.add("2010-03-02 05:00:00.000009001");
            ts.add("2005-01-01 06:00:00.000002229");
            ts.add("2006-01-01 07:00:00.900203003");
            ts.add("2003-01-01 08:00:00.800000007");
            ts.add("1996-08-02 09:00:00.723100809");
            ts.add("1998-11-02 10:00:00.857340643");
            ts.add("2008-10-02 11:00:00.0");
            ts.add("2037-01-01 00:00:00.000999");
            for (String t : ts) {
                writer.addRow((Object)Timestamp.valueOf(t));
            }
            writer.close();
            TimeZone.setDefault(TimeZone.getTimeZone(this.readerTimeZone));
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            Assert.assertEquals((String)this.readerTimeZone, (String)TimeZone.getDefault().getID());
            RecordReader rows = reader.rows(null);
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Timestamp got = ((TimestampWritable)row).getTimestamp();
                Assert.assertEquals((String)((String)ts.get(idx++)), (String)got.toString());
            }
            rows.close();
            return;
        }
    }
}

