/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponseElement;
import org.apache.hadoop.hive.metastore.txn.TxnDbUtil;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.lockmgr.DbLockManager;
import org.apache.hadoop.hive.ql.lockmgr.DbTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.TxnManagerFactory;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestDbTxnManager2 {
    private static HiveConf conf = new HiveConf(Driver.class);
    private HiveTxnManager txnMgr;
    private Context ctx;
    private Driver driver;

    @BeforeClass
    public static void setUpClass() throws Exception {
        TxnDbUtil.setConfValues((HiveConf)conf);
        conf.setVar(HiveConf.ConfVars.DYNAMICPARTITIONINGMODE, "nonstrict");
        conf.setBoolVar(HiveConf.ConfVars.HIVEENFORCEBUCKETING, true);
    }

    @Before
    public void setUp() throws Exception {
        SessionState.start((HiveConf)conf);
        this.ctx = new Context((Configuration)conf);
        this.driver = new Driver(conf);
        this.driver.init();
        TxnDbUtil.cleanDb();
        TxnDbUtil.prepDb();
        this.txnMgr = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        Assert.assertTrue((boolean)(this.txnMgr instanceof DbTxnManager));
    }

    @After
    public void tearDown() throws Exception {
        this.driver.close();
        if (this.txnMgr != null) {
            this.txnMgr.closeTxnManager();
        }
        TxnDbUtil.cleanDb();
        TxnDbUtil.prepDb();
    }

    @Test
    public void createTable() throws Exception {
        CommandProcessorResponse cpr = this.driver.compileAndRespond("create table if not exists T (a int, b int)");
        this.checkCmdOnDriver(cpr);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (int)1, (int)locks.size());
        this.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", null, null, locks.get(0));
        this.txnMgr.getLockManager().releaseLocks(this.ctx.getHiveLocks());
        Assert.assertEquals((String)"Lock remained", (int)0, (int)this.getLocks().size());
    }

    @Test
    public void insertOverwriteCreate() throws Exception {
        CommandProcessorResponse cpr = this.driver.run("create table if not exists T2(a int)");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("create table if not exists T3(a int)");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.compileAndRespond("insert overwrite table T3 select a from T2");
        this.checkCmdOnDriver(cpr);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (int)2, (int)locks.size());
        this.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T2", null, locks.get(0));
        this.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "T3", null, locks.get(1));
        this.txnMgr.getLockManager().releaseLocks(this.ctx.getHiveLocks());
        Assert.assertEquals((String)"Lock remained", (int)0, (int)this.getLocks().size());
        cpr = this.driver.run("drop table if exists T1");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("drop table if exists T2");
        this.checkCmdOnDriver(cpr);
    }

    @Test
    public void insertOverwritePartitionedCreate() throws Exception {
        CommandProcessorResponse cpr = this.driver.run("create table if not exists T4 (name string, gpa double) partitioned by (age int)");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("create table if not exists T5(name string, age int, gpa double)");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.compileAndRespond("INSERT OVERWRITE TABLE T4 PARTITION (age) SELECT name, age, gpa FROM T5");
        this.checkCmdOnDriver(cpr);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (int)2, (int)locks.size());
        this.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T5", null, locks.get(0));
        this.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "T4", null, locks.get(1));
        this.txnMgr.getLockManager().releaseLocks(this.ctx.getHiveLocks());
        Assert.assertEquals((String)"Lock remained", (int)0, (int)this.getLocks().size());
        cpr = this.driver.run("drop table if exists T5");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("drop table if exists T4");
        this.checkCmdOnDriver(cpr);
    }

    @Test
    public void basicBlocking() throws Exception {
        CommandProcessorResponse cpr = this.driver.run("create table if not exists T6(a int)");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.compileAndRespond("select a from T6");
        this.checkCmdOnDriver(cpr);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        List selectLocks = this.ctx.getHiveLocks();
        cpr = this.driver.compileAndRespond("drop table if exists T6");
        this.checkCmdOnDriver(cpr);
        LockState lockState = ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "Fiddler", false);
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (int)2, (int)locks.size());
        this.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T6", null, locks.get(0));
        this.checkLock(LockType.EXCLUSIVE, LockState.WAITING, "default", "T6", null, locks.get(1));
        this.txnMgr.getLockManager().releaseLocks(selectLocks);
        lockState = ((DbLockManager)this.txnMgr.getLockManager()).checkLock(locks.get(1).getLockid());
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (int)1, (int)locks.size());
        this.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "T6", null, locks.get(0));
        ArrayList<DbLockManager.DbHiveLock> xLock = new ArrayList<DbLockManager.DbHiveLock>(0);
        xLock.add(new DbLockManager.DbHiveLock(locks.get(0).getLockid()));
        this.txnMgr.getLockManager().releaseLocks(xLock);
        cpr = this.driver.run("drop table if exists T6");
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected number of locks found", (int)0, (int)locks.size());
        this.checkCmdOnDriver(cpr);
    }

    @Test
    public void lockConflictDbTable() throws Exception {
        CommandProcessorResponse cpr = this.driver.run("create database if not exists temp");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("create table if not exists temp.T7(a int, b int) clustered by(b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.compileAndRespond("update temp.T7 set a = 5 where b = 6");
        this.checkCmdOnDriver(cpr);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        List updateLocks = this.ctx.getHiveLocks();
        cpr = this.driver.compileAndRespond("drop database if exists temp");
        LockState lockState = ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "Fiddler", false);
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (int)2, (int)locks.size());
        this.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "temp", "T7", null, locks.get(0));
        this.checkLock(LockType.EXCLUSIVE, LockState.WAITING, "temp", null, null, locks.get(1));
        this.txnMgr.getLockManager().releaseLocks(updateLocks);
        lockState = ((DbLockManager)this.txnMgr.getLockManager()).checkLock(locks.get(1).getLockid());
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (int)1, (int)locks.size());
        this.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "temp", null, null, locks.get(0));
        ArrayList<DbLockManager.DbHiveLock> xLock = new ArrayList<DbLockManager.DbHiveLock>(0);
        xLock.add(new DbLockManager.DbHiveLock(locks.get(0).getLockid()));
        this.txnMgr.getLockManager().releaseLocks(xLock);
    }

    @Test
    public void updateSelectUpdate() throws Exception {
        CommandProcessorResponse cpr = this.driver.run("create table T8(a int, b int) clustered by(b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.compileAndRespond("delete from T8 where b = 89");
        this.checkCmdOnDriver(cpr);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        List deleteLocks = this.ctx.getHiveLocks();
        cpr = this.driver.compileAndRespond("select a from T8");
        this.checkCmdOnDriver(cpr);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fiddler");
        cpr = this.driver.compileAndRespond("update T8 set a = 1 where b = 1");
        this.checkCmdOnDriver(cpr);
        LockState lockState = ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "Practical", false);
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (int)3, (int)locks.size());
        this.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T8", null, locks.get(0));
        this.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "T8", null, locks.get(1));
        this.checkLock(LockType.SHARED_WRITE, LockState.WAITING, "default", "T8", null, locks.get(2));
        this.txnMgr.getLockManager().releaseLocks(deleteLocks);
        lockState = ((DbLockManager)this.txnMgr.getLockManager()).checkLock(locks.get(2).getLockid());
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (int)2, (int)locks.size());
        this.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T8", null, locks.get(0));
        this.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "T8", null, locks.get(1));
        ArrayList<DbLockManager.DbHiveLock> relLocks = new ArrayList<DbLockManager.DbHiveLock>(2);
        relLocks.add(new DbLockManager.DbHiveLock(locks.get(0).getLockid()));
        relLocks.add(new DbLockManager.DbHiveLock(locks.get(1).getLockid()));
        this.txnMgr.getLockManager().releaseLocks(relLocks);
        cpr = this.driver.run("drop table if exists T6");
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected number of locks found", (int)0, (int)locks.size());
        this.checkCmdOnDriver(cpr);
    }

    private void checkLock(LockType type, LockState state, String db, String table, String partition, ShowLocksResponseElement l) {
        Assert.assertEquals((String)l.toString(), (Object)l.getType(), (Object)type);
        Assert.assertEquals((String)l.toString(), (Object)l.getState(), (Object)state);
        Assert.assertEquals((String)l.toString(), (String)this.normalizeCase(l.getDbname()), (String)this.normalizeCase(db));
        Assert.assertEquals((String)l.toString(), (String)this.normalizeCase(l.getTablename()), (String)this.normalizeCase(table));
        Assert.assertEquals((String)l.toString(), (String)this.normalizeCase(l.getPartname()), (String)this.normalizeCase(partition));
    }

    private void checkCmdOnDriver(CommandProcessorResponse cpr) {
        Assert.assertTrue((String)cpr.toString(), (cpr.getResponseCode() == 0 ? 1 : 0) != 0);
    }

    private String normalizeCase(String s) {
        return s == null ? null : s.toLowerCase();
    }

    private List<ShowLocksResponseElement> getLocks() throws Exception {
        ShowLocksResponse rsp = ((DbLockManager)this.txnMgr.getLockManager()).getLocks();
        return rsp.getLocks();
    }
}

