/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.plan.ExplainWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Before;
import org.junit.Test;

public class TestUpdateDeleteSemanticAnalyzer {
    private static final Log LOG = LogFactory.getLog((String)TestUpdateDeleteSemanticAnalyzer.class.getName());
    private HiveConf conf;
    private Hive db;

    @Test
    public void testInsertSelect() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("insert into table T select a, b from U", "testInsertSelect");
            LOG.info((Object)this.explain((SemanticAnalyzer)rc.sem, rc.plan, rc.ast.dump()));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testDeleteAllNonPartitioned() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("delete from T", "testDeleteAllNonPartitioned");
            LOG.info((Object)this.explain((SemanticAnalyzer)rc.sem, rc.plan, rc.ast.dump()));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testDeleteWhereNoPartition() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("delete from T where a > 5", "testDeleteWhereNoPartition");
            LOG.info((Object)this.explain((SemanticAnalyzer)rc.sem, rc.plan, rc.ast.dump()));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testDeleteAllPartitioned() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("delete from U", "testDeleteAllPartitioned");
            LOG.info((Object)this.explain((SemanticAnalyzer)rc.sem, rc.plan, rc.ast.dump()));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testDeleteAllWherePartitioned() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("delete from U where a > 5", "testDeleteAllWherePartitioned");
            LOG.info((Object)this.explain((SemanticAnalyzer)rc.sem, rc.plan, rc.ast.dump()));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testDeleteOnePartition() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("delete from U where ds = 'today'", "testDeleteFromPartitionOnly");
            LOG.info((Object)this.explain((SemanticAnalyzer)rc.sem, rc.plan, rc.ast.dump()));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testDeleteOnePartitionWhere() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("delete from U where ds = 'today' and a > 5", "testDeletePartitionWhere");
            LOG.info((Object)this.explain((SemanticAnalyzer)rc.sem, rc.plan, rc.ast.dump()));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testUpdateAllNonPartitioned() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("update T set b = 5", "testUpdateAllNonPartitioned");
            LOG.info((Object)this.explain((SemanticAnalyzer)rc.sem, rc.plan, rc.ast.dump()));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testUpdateAllNonPartitionedWhere() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("update T set b = 5 where b > 5", "testUpdateAllNonPartitionedWhere");
            LOG.info((Object)this.explain((SemanticAnalyzer)rc.sem, rc.plan, rc.ast.dump()));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testUpdateAllPartitioned() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("update U set b = 5", "testUpdateAllPartitioned");
            LOG.info((Object)this.explain((SemanticAnalyzer)rc.sem, rc.plan, rc.ast.dump()));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testUpdateAllPartitionedWhere() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("update U set b = 5 where b > 5", "testUpdateAllPartitionedWhere");
            LOG.info((Object)this.explain((SemanticAnalyzer)rc.sem, rc.plan, rc.ast.dump()));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testUpdateOnePartition() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("update U set b = 5 where ds = 'today'", "testUpdateOnePartition");
            LOG.info((Object)this.explain((SemanticAnalyzer)rc.sem, rc.plan, rc.ast.dump()));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testUpdateOnePartitionWhere() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("update U set b = 5 where ds = 'today' and b > 5", "testUpdateOnePartitionWhere");
            LOG.info((Object)this.explain((SemanticAnalyzer)rc.sem, rc.plan, rc.ast.dump()));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testInsertValues() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("insert into table T values ('abc', 3), ('ghi', null)", "testInsertValues");
            LOG.info((Object)this.explain((SemanticAnalyzer)rc.sem, rc.plan, rc.ast.dump()));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testInsertValuesPartitioned() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("insert into table U partition (ds) values ('abc', 3, 'today'), ('ghi', 5, 'tomorrow')", "testInsertValuesPartitioned");
            LOG.info((Object)this.explain((SemanticAnalyzer)rc.sem, rc.plan, rc.ast.dump()));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Before
    public void setup() {
        this.conf = new HiveConf();
        this.conf.setVar(HiveConf.ConfVars.DYNAMICPARTITIONINGMODE, "nonstrict");
        this.conf.setVar(HiveConf.ConfVars.HIVE_TXN_MANAGER, "org.apache.hadoop.hive.ql.lockmgr.DbTxnManager");
    }

    public void cleanupTables() throws HiveException {
        if (this.db != null) {
            this.db.dropTable("T");
            this.db.dropTable("U");
        }
    }

    private ReturnInfo parseAndAnalyze(String query, String testName) throws IOException, ParseException, HiveException {
        SessionState.start((HiveConf)this.conf);
        Context ctx = new Context((Configuration)this.conf);
        ctx.setCmd(query);
        ctx.setHDFSCleanup(true);
        ParseDriver pd = new ParseDriver();
        ASTNode tree = pd.parse(query, ctx);
        tree = ParseUtils.findRootNonNullToken((ASTNode)tree);
        BaseSemanticAnalyzer sem = SemanticAnalyzerFactory.get((HiveConf)this.conf, (ASTNode)tree);
        SessionState.get().initTxnMgr(this.conf);
        this.db = sem.getDb();
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("transactional", "true");
        this.db.createTable("T", Arrays.asList("a", "b"), null, OrcInputFormat.class, OrcOutputFormat.class, 2, Arrays.asList("a"), params);
        this.db.createTable("U", Arrays.asList("a", "b"), Arrays.asList("ds"), OrcInputFormat.class, OrcOutputFormat.class, 2, Arrays.asList("a"), params);
        Table u = this.db.getTable("U");
        HashMap<String, String> partVals = new HashMap<String, String>(2);
        partVals.put("ds", "yesterday");
        this.db.createPartition(u, partVals);
        partVals.clear();
        partVals.put("ds", "today");
        this.db.createPartition(u, partVals);
        sem.analyze(tree, ctx);
        sem.validate();
        QueryPlan plan = new QueryPlan(query, sem, Long.valueOf(0L), testName, null);
        return new ReturnInfo(tree, sem, plan);
    }

    private String explain(SemanticAnalyzer sem, QueryPlan plan, String astStringTree) throws IOException {
        int bytesRead;
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        File f = File.createTempFile("TestSemanticAnalyzer", "explain");
        Path tmp = new Path(f.getPath());
        fs.create(tmp);
        fs.deleteOnExit(tmp);
        ExplainWork work = new ExplainWork(tmp, sem.getParseContext(), sem.getRootTasks(), (Task)sem.getFetchTask(), astStringTree, (BaseSemanticAnalyzer)sem, true, false, false, false, false, false, null);
        ExplainTask task = new ExplainTask();
        task.setWork((Serializable)work);
        task.initialize(this.conf, plan, null);
        task.execute(null);
        FSDataInputStream in = fs.open(tmp);
        StringBuilder builder = new StringBuilder();
        int bufSz = 4096;
        byte[] buf = new byte[4096];
        long pos = 0L;
        while ((bytesRead = in.read(pos, buf, 0, 4096)) > 0) {
            pos += (long)bytesRead;
            builder.append(new String(buf, 0, bytesRead));
        }
        in.close();
        return builder.toString().replaceAll("pfile:/.*\n", "pfile:MASKED-OUT\n").replaceAll("location file:/.*\n", "location file:MASKED-OUT\n").replaceAll("file:/.*\n", "file:MASKED-OUT\n").replaceAll("transient_lastDdlTime.*\n", "transient_lastDdlTime MASKED-OUT\n");
    }

    private class ReturnInfo {
        ASTNode ast;
        BaseSemanticAnalyzer sem;
        QueryPlan plan;

        ReturnInfo(ASTNode a, BaseSemanticAnalyzer s, QueryPlan p) {
            this.ast = a;
            this.sem = s;
            this.plan = p;
        }
    }
}

