/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.authorization;

import junit.framework.Assert;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.parse.authorization.AuthorizationTestUtil;
import org.apache.hadoop.hive.ql.parse.authorization.ListSizeMatcher;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.GrantDesc;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeDesc;
import org.apache.hadoop.hive.ql.security.authorization.PrivilegeType;

public class PrivilegesTestBase {
    protected static final String DB = "default";
    protected static final String TABLE = "table1";
    protected static final String TABLE_QNAME = "default.table1";
    protected static final String USER = "user1";

    public static void grantUserTable(String privStr, PrivilegeType privType, HiveConf conf, Hive db) throws Exception {
        DDLWork work = AuthorizationTestUtil.analyze("GRANT " + privStr + " ON TABLE " + TABLE + " TO USER " + USER, conf, db);
        GrantDesc grantDesc = work.getGrantDesc();
        Assert.assertNotNull((String)"Grant should not be null", (Object)grantDesc);
        for (PrivilegeDesc privilege : ListSizeMatcher.inList(grantDesc.getPrivileges()).ofSize(1)) {
            Assert.assertEquals((Object)privType, (Object)privilege.getPrivilege().getPriv());
        }
        for (PrincipalDesc principal : ListSizeMatcher.inList(grantDesc.getPrincipals()).ofSize(1)) {
            Assert.assertEquals((Object)PrincipalType.USER, (Object)principal.getType());
            Assert.assertEquals((String)USER, (String)principal.getName());
        }
        Assert.assertTrue((String)"Expected table", (boolean)grantDesc.getPrivilegeSubjectDesc().getTable());
        Assert.assertEquals((String)TABLE_QNAME, (String)grantDesc.getPrivilegeSubjectDesc().getObject());
    }
}

